/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v850.processors.es;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.FlowNodeType;
import io.camunda.tasklist.entities.ProcessInstanceEntity;
import io.camunda.tasklist.entities.ProcessInstanceState;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.util.ConversionUtils;
import io.camunda.tasklist.util.DateUtil;
import io.camunda.tasklist.zeebeimport.v850.record.value.ProcessInstanceRecordValueImpl;
import io.camunda.zeebe.protocol.v850.record.Record;
import io.camunda.zeebe.protocol.v850.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.v850.record.value.BpmnElementType;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessInstanceZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceZeebeRecordProcessorElasticSearch.class);
    private static final Set<String> FLOW_NODE_STATES = new HashSet<String>();
    private static final Set<String> PROCESS_INSTANCE_STATES = new HashSet<String>();
    private static final List<BpmnElementType> VARIABLE_SCOPE_TYPES = Arrays.asList(BpmnElementType.PROCESS, BpmnElementType.SUB_PROCESS, BpmnElementType.EVENT_SUB_PROCESS, BpmnElementType.SERVICE_TASK, BpmnElementType.USER_TASK, BpmnElementType.MULTI_INSTANCE_BODY);
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private ProcessInstanceIndex processInstanceIndex;

    public void processProcessInstanceRecord(Record record, BulkRequest bulkRequest) throws PersistenceException {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        if (this.isVariableScopeType(recordValue) && FLOW_NODE_STATES.contains(record.getIntent().name())) {
            FlowNodeInstanceEntity flowNodeInstance = this.createFlowNodeInstance(record);
            bulkRequest.add(this.getFlowNodeInstanceQuery(flowNodeInstance));
        }
        if (this.isProcessEvent(recordValue) && PROCESS_INSTANCE_STATES.contains(record.getIntent().name())) {
            ProcessInstanceEntity processInstanceEntity = this.createProcessInstance(record);
            bulkRequest.add(this.getProcessInstanceQuery(processInstanceEntity));
        }
    }

    private ProcessInstanceEntity createProcessInstance(Record record) {
        ProcessInstanceEntity entity = new ProcessInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        if (ProcessInstanceIntent.ELEMENT_COMPLETED.name().equals(record.getIntent().name())) {
            entity.setState(ProcessInstanceState.COMPLETED);
        } else if (ProcessInstanceIntent.ELEMENT_TERMINATED.name().equals(record.getIntent().name())) {
            entity.setState(ProcessInstanceState.CANCELED);
        }
        entity.setEndDate(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
        return entity;
    }

    private FlowNodeInstanceEntity createFlowNodeInstance(Record record) {
        ProcessInstanceRecordValueImpl recordValue = (ProcessInstanceRecordValueImpl)record.getValue();
        FlowNodeInstanceEntity entity = new FlowNodeInstanceEntity();
        entity.setId(ConversionUtils.toStringOrNull((Object)record.getKey()));
        entity.setKey(record.getKey());
        entity.setPartitionId(record.getPartitionId());
        entity.setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey()));
        entity.setParentFlowNodeId(String.valueOf(recordValue.getFlowScopeKey()));
        entity.setType(FlowNodeType.fromZeebeBpmnElementType(recordValue.getBpmnElementType() == null ? null : recordValue.getBpmnElementType().name()));
        entity.setPosition(Long.valueOf(record.getPosition()));
        return entity;
    }

    private IndexRequest getFlowNodeInstanceQuery(FlowNodeInstanceEntity entity) throws PersistenceException {
        try {
            LOGGER.debug("Flow node instance: id {}", (Object)entity.getId());
            return new IndexRequest(this.flowNodeInstanceIndex.getFullQualifiedName()).id(entity.getId()).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to index flow node instance [%s]", entity.getId()), (Throwable)e);
        }
    }

    private IndexRequest getProcessInstanceQuery(ProcessInstanceEntity entity) throws PersistenceException {
        try {
            LOGGER.debug("Process instance: id {}", (Object)entity.getId());
            return ((IndexRequest)new IndexRequest().index(this.processInstanceIndex.getFullQualifiedName())).id(entity.getId()).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to index process instance [%s]w", entity.getId()), (Throwable)e);
        }
    }

    private boolean isVariableScopeType(ProcessInstanceRecordValueImpl recordValue) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return VARIABLE_SCOPE_TYPES.contains((Object)bpmnElementType);
    }

    private boolean isProcessEvent(ProcessInstanceRecordValueImpl recordValue) {
        return this.isOfType(recordValue, BpmnElementType.PROCESS);
    }

    private boolean isOfType(ProcessInstanceRecordValueImpl recordValue, BpmnElementType type) {
        BpmnElementType bpmnElementType = recordValue.getBpmnElementType();
        if (bpmnElementType == null) {
            return false;
        }
        return bpmnElementType.equals((Object)type);
    }

    static {
        FLOW_NODE_STATES.add(ProcessInstanceIntent.ELEMENT_ACTIVATING.name());
        PROCESS_INSTANCE_STATES.add(ProcessInstanceIntent.ELEMENT_COMPLETED.name());
        PROCESS_INSTANCE_STATES.add(ProcessInstanceIntent.ELEMENT_TERMINATED.name());
    }
}

