/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.v850.processors.es;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskImplementation;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.util.DateUtil;
import io.camunda.tasklist.zeebeimport.v850.record.Intent;
import io.camunda.tasklist.zeebeimport.v850.record.value.JobRecordValueImpl;
import io.camunda.zeebe.protocol.v850.record.Record;
import java.io.IOException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class JobZeebeRecordProcessorElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobZeebeRecordProcessorElasticSearch.class);
    private static final Pattern EMBEDDED_FORMS_PATTERN = Pattern.compile("^camunda-forms:bpmn:.*");
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private FormStore formStore;

    public void processJobRecord(Record<JobRecordValueImpl> record, BulkRequest bulkRequest) throws PersistenceException {
        JobRecordValueImpl recordValue = record.getValue();
        if (recordValue.getType().equals("io.camunda.zeebe:userTask") && record.getIntent() != null && !record.getIntent().name().equals(Intent.TIMED_OUT.name())) {
            bulkRequest.add(this.persistTask(record, recordValue));
        }
    }

    private UpdateRequest persistTask(Record<JobRecordValueImpl> record, JobRecordValueImpl recordValue) throws PersistenceException {
        String candidateUsers;
        String candidateGroups;
        OffsetDateTime offSetFollowUpDate;
        String followUpDate;
        OffsetDateTime offSetDueDate;
        String processDefinitionId = String.valueOf(recordValue.getProcessDefinitionKey());
        TaskEntity entity = (TaskEntity)((TaskEntity)((TaskEntity)((TaskEntity)new TaskEntity().setImplementation(TaskImplementation.JOB_WORKER).setId(String.valueOf(record.getKey()))).setKey(record.getKey())).setPartitionId(record.getPartitionId())).setFlowNodeBpmnId(recordValue.getElementId()).setFlowNodeInstanceId(String.valueOf(recordValue.getElementInstanceKey())).setProcessInstanceId(String.valueOf(recordValue.getProcessInstanceKey())).setBpmnProcessId(recordValue.getBpmnProcessId()).setProcessDefinitionId(processDefinitionId).setTenantId(recordValue.getTenantId());
        String dueDate = recordValue.getCustomHeaders().get("io.camunda.zeebe:dueDate");
        if (dueDate != null && (offSetDueDate = DateUtil.toOffsetDateTime((String)dueDate)) != null) {
            entity.setDueDate(offSetDueDate);
        }
        if ((followUpDate = recordValue.getCustomHeaders().get("io.camunda.zeebe:followUpDate")) != null && (offSetFollowUpDate = DateUtil.toOffsetDateTime((String)followUpDate)) != null) {
            entity.setFollowUpDate(offSetFollowUpDate);
        }
        String formKey = recordValue.getCustomHeaders().get("io.camunda.zeebe:formKey");
        entity.setFormKey(formKey);
        Optional.ofNullable(formKey).flatMap(arg_0 -> ((FormStore)this.formStore).getFormByKey(arg_0)).ifPresentOrElse(linkedForm -> {
            entity.setFormVersion(linkedForm.version());
            entity.setFormId(linkedForm.bpmnId());
            entity.setIsFormEmbedded(Boolean.valueOf(false));
        }, () -> {
            entity.setIsFormEmbedded(Boolean.valueOf(formKey != null && EMBEDDED_FORMS_PATTERN.matcher(formKey).matches()));
            entity.setFormVersion(null);
            entity.setFormId(null);
        });
        String assignee = recordValue.getCustomHeaders().get("io.camunda.zeebe:assignee");
        if (assignee != null) {
            entity.setAssignee(assignee);
        }
        if ((candidateGroups = recordValue.getCustomHeaders().get("io.camunda.zeebe:candidateGroups")) != null) {
            try {
                entity.setCandidateGroups((String[])this.objectMapper.readValue(candidateGroups, String[].class));
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(String.format("Candidate groups can't be parsed from %s: %s", candidateGroups, e.getMessage()), (Throwable)e);
            }
        }
        if ((candidateUsers = recordValue.getCustomHeaders().get("io.camunda.zeebe:candidateUsers")) != null) {
            try {
                entity.setCandidateUsers((String[])this.objectMapper.readValue(candidateUsers, String[].class));
            }
            catch (JsonProcessingException e) {
                LOGGER.warn(String.format("Candidate users can't be parsed from %s: %s", candidateUsers, e.getMessage()), (Throwable)e);
            }
        }
        Intent intent = (Intent)record.getIntent();
        LOGGER.debug("Intent {}", (Object)intent);
        switch (intent) {
            case CANCELED: {
                entity.setState(TaskState.CANCELED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case COMPLETED: {
                entity.setState(TaskState.COMPLETED).setCompletionTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case CREATED: {
                entity.setState(TaskState.CREATED).setCreationTime(DateUtil.toOffsetDateTime((Instant)Instant.ofEpochMilli(record.getTimestamp())));
                break;
            }
            case MIGRATED: 
            case RECURRED_AFTER_BACKOFF: {
                entity.setState(TaskState.CREATED);
                break;
            }
            case FAILED: {
                if (recordValue.getRetries() > 0) {
                    if (recordValue.getRetryBackoff() > 0L) {
                        entity.setState(TaskState.FAILED);
                        break;
                    }
                    entity.setState(TaskState.CREATED);
                    break;
                }
                entity.setState(TaskState.FAILED);
                break;
            }
            default: {
                LOGGER.warn(String.format("Intent %s not supported", intent));
            }
        }
        return this.getTaskQuery(entity, intent);
    }

    private UpdateRequest getTaskQuery(TaskEntity entity, Intent intent) throws PersistenceException {
        try {
            HashMap<String, Object> updateFields = new HashMap<String, Object>();
            LOGGER.debug("Task instance: id {}", (Object)entity.getId());
            if (intent == Intent.MIGRATED) {
                updateFields.put("flowNodeBpmnId", entity.getFlowNodeBpmnId());
                updateFields.put("bpmnProcessId", entity.getBpmnProcessId());
                updateFields.put("processDefinitionId", entity.getProcessDefinitionId());
            } else {
                if (entity.getState() != null) {
                    updateFields.put("state", entity.getState());
                }
                updateFields.put("completionTime", entity.getCompletionTime());
            }
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            return ((UpdateRequest)new UpdateRequest().index(this.taskTemplate.getFullQualifiedName())).id(entity.getId()).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).doc(jsonMap).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert task instance [%s]", entity.getId()), (Throwable)e);
        }
    }
}

