/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch.dao.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskResponse {
    @JsonProperty(value="completed")
    private boolean completed;
    @JsonProperty(value="task")
    private Task task;
    @JsonProperty(value="error")
    private Error error;
    @JsonProperty(value="response")
    private TaskResponseDetails responseDetails;

    public boolean isCompleted() {
        return this.completed;
    }

    public Task getTask() {
        return this.task;
    }

    @JsonIgnore
    public Status getTaskStatus() {
        return Optional.ofNullable(this.task).flatMap(Task::getStatus).orElse(null);
    }

    @JsonIgnore
    public Double getProgress() {
        return Optional.ofNullable(this.task).flatMap(Task::getStatus).filter(status -> status.getTotal() != 0L).map(status -> (double)(status.getCreated() + status.getUpdated() + status.getDeleted()) / (double)status.getTotal().longValue()).orElse(0.0);
    }

    public TaskResponseDetails getResponseDetails() {
        return this.responseDetails;
    }

    public Error getError() {
        return this.error;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Task {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="status")
        private Status status;

        public String getId() {
            return this.id;
        }

        @JsonIgnore
        public Optional<Status> getStatus() {
            return Optional.ofNullable(this.status);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Status {
        @JsonProperty(value="total")
        private Long total;
        @JsonProperty(value="updated")
        private Long updated;
        @JsonProperty(value="created")
        private Long created;
        @JsonProperty(value="deleted")
        private Long deleted;

        public Long getTotal() {
            return this.total;
        }

        public Long getUpdated() {
            return this.updated;
        }

        public Long getCreated() {
            return this.created;
        }

        public Long getDeleted() {
            return this.deleted;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TaskResponseDetails {
        @JsonProperty(value="failures")
        private List<Object> failures;

        public List<Object> getFailures() {
            return this.failures;
        }
    }

    public static class Error {
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="reason")
        private String reason;
        @JsonProperty(value="script_stack")
        private List<String> scriptStack;
        @JsonProperty(value="caused_by")
        private Map<String, Object> causedBy;

        public String getType() {
            return this.type;
        }

        public String getReason() {
            return this.reason;
        }

        public List<String> getScriptStack() {
            return this.scriptStack;
        }

        public Map<String, Object> getCausedBy() {
            return this.causedBy;
        }

        public String toString() {
            String scriptStackString = this.scriptStack == null ? null : this.scriptStack.stream().map(stackLine -> "\n" + stackLine).collect(Collectors.toList()).toString();
            String causedByString = Optional.ofNullable(this.causedBy).map(causes -> causes.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(entry -> (String)entry.getKey() + "=" + String.valueOf(entry.getValue())).collect(Collectors.joining(",", "'{", "}'"))).orElse(null);
            return "Error{type='" + this.type + "', reason='" + this.reason + "', script_stack='" + scriptStackString + "'\ncaused_by=" + causedByString + "}";
        }
    }
}

