/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.store.VariableStore;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.CollectionUtil;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class VariableStoreElasticSearch
implements VariableStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(VariableStoreElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public List<VariableEntity> getVariablesByFlowNodeInstanceIds(List<String> flowNodeInstanceIds, List<String> varNames, Set<String> fieldNames) {
        TermsQueryBuilder flowNodeInstanceKeyQ = QueryBuilders.termsQuery((String)"scopeFlowNodeId", flowNodeInstanceIds);
        TermsQueryBuilder varNamesQ = null;
        if (CollectionUtil.isNotEmpty(varNames)) {
            varNamesQ = QueryBuilders.termsQuery((String)"name", varNames);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{flowNodeInstanceKeyQ, varNamesQ})));
        this.applyFetchSourceForVariableIndex(searchSourceBuilder, fieldNames);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.variableIndex.getAlias()}).source(searchSourceBuilder);
        try {
            return ElasticsearchUtil.scroll(searchRequest, VariableEntity.class, this.objectMapper, this.esClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all variables: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<String, List<TaskVariableEntity>> getTaskVariablesPerTaskId(List<VariableStore.GetVariablesRequest> requests) {
        if (requests == null || requests.size() == 0) {
            return new HashMap<String, List<TaskVariableEntity>>();
        }
        TermsQueryBuilder taskIdsQ = QueryBuilders.termsQuery((String)"taskId", (Collection)requests.stream().map(VariableStore.GetVariablesRequest::getTaskId).collect(Collectors.toList()));
        List varNames = requests.stream().map(VariableStore.GetVariablesRequest::getVarNames).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        TermsQueryBuilder varNamesQ = null;
        if (CollectionUtil.isNotEmpty(varNames)) {
            varNamesQ = QueryBuilders.termsQuery((String)"name", varNames);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{taskIdsQ, varNamesQ})));
        this.applyFetchSourceForTaskVariableTemplate(searchSourceBuilder, requests.get(0).getFieldNames());
        SearchRequest searchRequest = new SearchRequest(new String[]{this.taskVariableTemplate.getAlias()}).source(searchSourceBuilder);
        try {
            List<TaskVariableEntity> entities = ElasticsearchUtil.scroll(searchRequest, TaskVariableEntity.class, this.objectMapper, this.esClient);
            return entities.stream().collect(Collectors.groupingBy(TaskVariableEntity::getTaskId, Collectors.mapping(Function.identity(), Collectors.toList())));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all variables: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<String, String> getTaskVariablesIdsWithIndexByTaskIds(List<String> taskIds) {
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.taskVariableTemplate).source(SearchSourceBuilder.searchSource().query((QueryBuilder)QueryBuilders.termsQuery((String)"taskId", taskIds)).fetchField("id"));
        try {
            return ElasticsearchUtil.scrollIdsWithIndexToMap(searchRequest, this.esClient);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void persistTaskVariables(Collection<TaskVariableEntity> finalVariables) {
        BulkRequest bulkRequest = new BulkRequest();
        for (TaskVariableEntity variableEntity : finalVariables) {
            bulkRequest.add(this.createUpsertRequest(variableEntity));
        }
        try {
            ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, WriteRequest.RefreshPolicy.WAIT_UNTIL);
        }
        catch (PersistenceException ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private UpdateRequest createUpsertRequest(TaskVariableEntity variableEntity) {
        try {
            HashMap<String, String> updateFields = new HashMap<String, String>();
            updateFields.put("taskId", variableEntity.getTaskId());
            updateFields.put("name", variableEntity.getName());
            updateFields.put("value", variableEntity.getValue());
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class);
            return ((UpdateRequest)new UpdateRequest().index(this.taskVariableTemplate.getFullQualifiedName())).id(variableEntity.getId()).upsert(this.objectMapper.writeValueAsString((Object)variableEntity), XContentType.JSON).doc(jsonMap).retryOnConflict(3);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException(String.format("Error preparing the query to upsert task variable instance [%s]", variableEntity.getId()), (Throwable)e);
        }
    }

    @Override
    public List<FlowNodeInstanceEntity> getFlowNodeInstances(List<String> processInstanceIds) {
        TermsQueryBuilder processInstanceKeyQuery = QueryBuilders.termsQuery((String)"processInstanceId", processInstanceIds);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.flowNodeInstanceIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)processInstanceKeyQuery)).sort("position", SortOrder.ASC).size(this.tasklistProperties.getElasticsearch().getBatchSize()));
        try {
            return ElasticsearchUtil.scroll(searchRequest, FlowNodeInstanceEntity.class, this.objectMapper, this.esClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all flow nodes: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public VariableEntity getRuntimeVariable(String variableId, Set<String> fieldNames) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{variableId}));
        this.applyFetchSourceForVariableIndex(searchSourceBuilder, fieldNames);
        SearchRequest request = new SearchRequest(new String[]{this.variableIndex.getAlias()}).source(searchSourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value == 1L) {
                return ElasticsearchUtil.fromSearchHit(response.getHits().getHits()[0].getSourceAsString(), this.objectMapper, VariableEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Unique variable with id %s was not found", variableId));
            }
            throw new NotFoundException(String.format("Variable with id %s was not found", variableId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining variable: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public TaskVariableEntity getTaskVariable(String variableId, Set<String> fieldNames) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.idsQuery().addIds(new String[]{variableId}));
        this.applyFetchSourceForTaskVariableTemplate(searchSourceBuilder, fieldNames);
        SearchRequest request = ElasticsearchUtil.createSearchRequest(this.taskVariableTemplate).source(searchSourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value == 1L) {
                return ElasticsearchUtil.fromSearchHit(response.getHits().getHits()[0].getSourceAsString(), this.objectMapper, TaskVariableEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Unique task variable with id %s was not found", variableId));
            }
            throw new NotFoundException(String.format("Task variable with id %s was not found", variableId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining task variable: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private void applyFetchSourceForVariableIndex(SearchSourceBuilder searchSourceBuilder, Set<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            Set<String> elsFieldNames = VariableIndex.getElsFieldsByGraphqlFields(fieldNames);
            elsFieldNames.add("id");
            elsFieldNames.add("name");
            elsFieldNames.add("scopeFlowNodeId");
            String[] includesFields = elsFieldNames.toArray(new String[elsFieldNames.size()]);
            searchSourceBuilder.fetchSource(includesFields, null);
        }
    }

    private void applyFetchSourceForTaskVariableTemplate(SearchSourceBuilder searchSourceBuilder, Set<String> fieldNames) {
        if (CollectionUtil.isNotEmpty(fieldNames)) {
            Set<String> elsFieldNames = TaskVariableTemplate.getElsFieldsByGraphqlFields(fieldNames);
            elsFieldNames.add("id");
            elsFieldNames.add("name");
            elsFieldNames.add("taskId");
            String[] includesFields = elsFieldNames.toArray(new String[elsFieldNames.size()]);
            searchSourceBuilder.fetchSource(includesFields, null);
        }
    }

    @Override
    public List<String> getProcessInstanceIdsWithMatchingVars(List<String> varNames, List<String> varValues) {
        ArrayList listProcessIdsMatchingVars = new ArrayList();
        for (int i = 0; i < varNames.size(); ++i) {
            BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"name", (String)varNames.get(i)));
            boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)varValues.get(i)));
            SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)boolQuery).fetchSource("processInstanceId", null);
            SearchRequest searchRequest = new SearchRequest(new String[]{this.variableIndex.getAlias()}).source(searchSourceBuilder);
            searchRequest.scroll(new TimeValue(60000L));
            HashSet processInstanceIds = new HashSet();
            try {
                SearchResponse searchResponse = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
                String scrollId = searchResponse.getScrollId();
                List<Object> scrollProcessIds = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> (String)hit.getSourceAsMap().get("processInstanceId")).collect(Collectors.toList());
                processInstanceIds.addAll(scrollProcessIds);
                while (scrollProcessIds.size() > 0) {
                    SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(new TimeValue(60000L));
                    searchResponse = this.esClient.scroll(scrollRequest, RequestOptions.DEFAULT);
                    scrollId = searchResponse.getScrollId();
                    scrollProcessIds = Arrays.stream(searchResponse.getHits().getHits()).map(hit -> (String)hit.getSourceAsMap().get("processInstanceId")).toList();
                    processInstanceIds.addAll(scrollProcessIds);
                }
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(scrollId);
                this.esClient.clearScroll(clearScrollRequest, RequestOptions.DEFAULT);
                listProcessIdsMatchingVars.add(processInstanceIds);
                continue;
            }
            catch (IOException e) {
                String message = String.format("Exception occurred while obtaining flowNodeInstanceIds for variable %s: %s", varNames.get(i), e.getMessage());
                throw new TasklistRuntimeException(message, (Throwable)e);
            }
        }
        return new ArrayList<String>(listProcessIdsMatchingVars.stream().reduce((set1, set2) -> {
            set1.retainAll((Collection<?>)set2);
            return set1;
        }).orElse(Collections.emptySet()));
    }
}

