/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.templates;

import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractTemplateDescriptor
implements TemplateDescriptor {
    private static final String SCHEMA_CREATE_TEMPLATE_JSON_ELASTICSEARCH = "/schema/es/create/template/tasklist-%s.json";
    private static final String SCHEMA_CREATE_TEMPLATE_JSON_OPENSEARCH = "/schema/os/create/template/tasklist-%s.json";
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public String getFullQualifiedName() {
        String indexPrefix = "elasticsearch".equals(this.tasklistProperties.getDatabase()) ? this.tasklistProperties.getElasticsearch().getIndexPrefix() : this.tasklistProperties.getOpenSearch().getIndexPrefix();
        return String.format("%s-%s-%s_", indexPrefix, this.getIndexName(), this.getVersion());
    }

    @Override
    public String getSchemaClasspathFilename() {
        if ("elasticsearch".equals(this.tasklistProperties.getDatabase())) {
            return String.format(SCHEMA_CREATE_TEMPLATE_JSON_ELASTICSEARCH, this.getIndexName());
        }
        return String.format(SCHEMA_CREATE_TEMPLATE_JSON_OPENSEARCH, this.getIndexName());
    }

    @Override
    public String getAllVersionsIndexNameRegexPattern() {
        return String.format("%s-%s-\\d.*", this.tasklistProperties.getIndexPrefix(), this.getIndexName());
    }
}

