/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration.os;

import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.schema.migration.Step;
import io.camunda.tasklist.util.CollectionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.reindex.Destination;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexPlanOpenSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexPlanOpenSearch.class);
    private static final String DEFAULT_SCRIPT = "ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()))";
    private List<Step> steps = List.of();
    private Script script;
    private String srcIndex;
    private String dstIndex;
    private int reindexBatchSize = 1000;
    private int slices;

    public Script getScript() {
        return this.script;
    }

    public ReindexPlanOpenSearch buildScript(Script script) {
        this.script = script;
        return this;
    }

    public String getSrcIndex() {
        return this.srcIndex;
    }

    public ReindexPlanOpenSearch setSrcIndex(String srcIndex) {
        this.srcIndex = srcIndex;
        return this;
    }

    public String getDstIndex() {
        return this.dstIndex;
    }

    public ReindexPlanOpenSearch setDstIndex(String dstIndex) {
        this.dstIndex = dstIndex;
        return this;
    }

    public ReindexPlanOpenSearch buildScript(String scriptContent, Map<String, JsonData> params) {
        this.script = Script.of(s -> s.inline(is -> (ObjectBuilder)is.lang("painless").source(scriptContent).params(params)));
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public ReindexPlanOpenSearch setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOn(RetryOpenSearchClient retryOpenSearchClient) throws MigrationException {
        Optional<String> pipelineName = this.createPipelineFromSteps(retryOpenSearchClient);
        ReindexRequest.Builder reindexRequestBuilder = new ReindexRequest.Builder().source(s -> s.index(this.srcIndex + "_*", new String[0]).size(Integer.valueOf(this.reindexBatchSize))).slices(Long.valueOf(this.slices)).waitForCompletion(Boolean.valueOf(false)).dest(d -> {
            pipelineName.ifPresent(arg_0 -> ((Destination.Builder)d).pipeline(arg_0));
            return d.index(this.dstIndex + "_");
        });
        if (this.script == null) {
            this.buildScript(DEFAULT_SCRIPT, Map.of("dstIndex", JsonData.of((Object)this.dstIndex)));
        }
        reindexRequestBuilder.script(this.script);
        try {
            retryOpenSearchClient.reindex(reindexRequestBuilder.build());
        }
        finally {
            pipelineName.ifPresent(retryOpenSearchClient::removePipeline);
        }
    }

    private Optional<String> createPipelineFromSteps(RetryOpenSearchClient retryOpenSearchClient) throws MigrationException {
        if (this.steps.isEmpty()) {
            return Optional.empty();
        }
        String name = this.srcIndex + "-to-" + this.dstIndex + "-pipeline";
        boolean added = retryOpenSearchClient.addPipeline(name, this.getPipelineDefinitions());
        if (added) {
            return Optional.of(name);
        }
        throw new MigrationException(String.format("Couldn't create '%s' pipeline.", name));
    }

    private List<String> getPipelineDefinitions() {
        return CollectionUtil.map(this.steps, Step::getContent);
    }

    public String toString() {
        return "ReindexPlanElasticSearch [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }

    public ReindexPlanOpenSearch setBatchSize(int reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
        return this;
    }

    public ReindexPlanOpenSearch setSlices(int slices) {
        this.slices = slices;
        return this;
    }

    public static ReindexPlanOpenSearch create() {
        return new ReindexPlanOpenSearch();
    }
}

