/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.manager;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.os.RetryOpenSearchClient;
import io.camunda.tasklist.property.TasklistOpenSearchProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.IndexMapping;
import io.camunda.tasklist.schema.indices.AbstractIndexDescriptor;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.manager.SchemaManager;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.RestClient;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.jsonb.JsonbJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.mapping.Property;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.cluster.PutComponentTemplateRequest;
import org.opensearch.client.opensearch.indices.Alias;
import org.opensearch.client.opensearch.indices.CreateIndexRequest;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.opensearch.indices.PutIndexTemplateRequest;
import org.opensearch.client.opensearch.indices.PutMappingRequest;
import org.opensearch.client.opensearch.indices.put_index_template.IndexTemplateMapping;
import org.opensearch.client.transport.OpenSearchTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;

@Component(value="tasklistSchemaManager")
@Profile(value={"!test"})
@Conditional(value={OpenSearchCondition.class})
public class OpenSearchSchemaManager
implements SchemaManager {
    public static final String SETTINGS = "settings";
    public static final String MAPPINGS = "properties";
    public static final String TASKLIST_DELETE_ARCHIVED_INDICES = "tasklist_delete_archived_indices";
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSearchSchemaManager.class);
    @Autowired
    protected TasklistProperties tasklistProperties;
    @Autowired
    protected RetryOpenSearchClient retryOpenSearchClient;
    @Autowired
    @Qualifier(value="tasklistOsRestClient")
    private RestClient opensearchRestClient;
    @Autowired
    private List<TemplateDescriptor> templateDescriptors;
    @Autowired
    private List<AbstractIndexDescriptor> indexDescriptors;
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient openSearchClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public void createSchema() {
        if (this.tasklistProperties.getArchiver().isIlmEnabled()) {
            this.createIndexLifeCyclesIfNotExist();
        }
        this.createDefaults();
        this.createTemplates();
        this.createIndices();
    }

    @Override
    public IndexMapping getExpectedIndexFields(IndexDescriptor indexDescriptor) {
        InputStream description = OpenSearchSchemaManager.class.getResourceAsStream(indexDescriptor.getSchemaClasspathFilename());
        try {
            String currentVersionSchema = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            TypeReference<HashMap<String, Object>> type = new TypeReference<HashMap<String, Object>>(this){};
            Map properties = (Map)((HashMap)this.objectMapper.readValue(currentVersionSchema, (TypeReference)type)).get(MAPPINGS);
            String dynamic = (String)((HashMap)this.objectMapper.readValue(currentVersionSchema, (TypeReference)type)).get("dynamic");
            return new IndexMapping().setIndexName(indexDescriptor.getIndexName()).setDynamic(dynamic).setProperties(properties.entrySet().stream().map(entry -> new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(entry.getValue())).collect(Collectors.toSet()));
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, IndexMapping> getIndexMappings(String indexNamePattern) throws IOException {
        HashMap<String, IndexMapping> mappings = new HashMap<String, IndexMapping>();
        Request request = new Request("GET", "/" + indexNamePattern + "/_mapping/");
        Response response = this.opensearchRestClient.performRequest(request);
        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
        ObjectMapper objectMapper = new ObjectMapper();
        Map parsedResponse = (Map)objectMapper.readValue(responseBody, (TypeReference)new TypeReference<Map<String, Map<String, Map<String, Object>>>>(this){});
        for (Map.Entry indexEntry : parsedResponse.entrySet()) {
            String indexName = (String)indexEntry.getKey();
            Map indexMappingData = (Map)((Map)indexEntry.getValue()).get("mappings");
            String dynamicSetting = (String)indexMappingData.get("dynamic");
            Map propertiesData = (Map)indexMappingData.get(MAPPINGS);
            HashSet<IndexMapping.IndexMappingProperty> propertiesSet = new HashSet<IndexMapping.IndexMappingProperty>();
            for (Map.Entry propertyEntry : propertiesData.entrySet()) {
                IndexMapping.IndexMappingProperty property = new IndexMapping.IndexMappingProperty().setName((String)propertyEntry.getKey()).setTypeDefinition(propertyEntry.getValue());
                propertiesSet.add(property);
            }
            IndexMapping indexMapping = new IndexMapping().setIndexName(indexName).setDynamic(dynamicSetting).setProperties(propertiesSet);
            mappings.put(indexName, indexMapping);
        }
        return mappings;
    }

    @Override
    public String getIndexPrefix() {
        return this.tasklistProperties.getOpenSearch().getIndexPrefix();
    }

    @Override
    public void updateSchema(Map<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> newFields) {
        for (Map.Entry<IndexDescriptor, Set<IndexMapping.IndexMappingProperty>> indexNewFields : newFields.entrySet()) {
            Map properties;
            if (indexNewFields.getKey() instanceof TemplateDescriptor) {
                LOGGER.info("Update template: " + ((TemplateDescriptor)indexNewFields.getKey()).getTemplateName());
                TemplateDescriptor templateDescriptor = (TemplateDescriptor)indexNewFields.getKey();
                String json = OpenSearchSchemaManager.readTemplateJson(templateDescriptor.getSchemaClasspathFilename());
                PutIndexTemplateRequest indexTemplateRequest = this.prepareIndexTemplateRequest(templateDescriptor, json);
                this.putIndexTemplate(indexTemplateRequest);
            }
            try (JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(IndexMapping.IndexMappingProperty.toJsonString(indexNewFields.getValue(), this.objectMapper)));){
                JsonpMapper jsonpMapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
                properties = (Map)JsonpDeserializer.stringMapDeserializer((JsonpDeserializer)Property._DESERIALIZER).deserialize(jsonParser, jsonpMapper);
            }
            PutMappingRequest request = new PutMappingRequest.Builder().index(indexNewFields.getKey().getAlias(), new String[0]).properties(properties).build();
            LOGGER.info(String.format("Index alias: %s. New fields will be added: %s", indexNewFields.getKey().getAlias(), indexNewFields.getValue()));
            this.retryOpenSearchClient.putMapping(request);
        }
    }

    @Override
    public void createIndex(IndexDescriptor indexDescriptor) {
        String indexFilename = indexDescriptor.getSchemaClasspathFilename();
        InputStream indexDescription = OpenSearchSchemaManager.class.getResourceAsStream(indexFilename);
        JsonpMapper mapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
        JsonParser parser = mapper.jsonProvider().createParser(indexDescription);
        CreateIndexRequest request = new CreateIndexRequest.Builder().mappings((TypeMapping)TypeMapping._DESERIALIZER.deserialize(parser, mapper)).aliases(indexDescriptor.getAlias(), new Alias.Builder().isWriteIndex(Boolean.valueOf(false)).build()).settings(this.getIndexSettings()).index(indexDescriptor.getFullQualifiedName()).build();
        this.createIndex(request, indexDescriptor.getFullQualifiedName());
    }

    private PutIndexTemplateRequest prepareIndexTemplateRequest(TemplateDescriptor templateDescriptor, String json) {
        IndexSettings templateSettings = this.templateSettings(templateDescriptor);
        IndexTemplateMapping.Builder templateBuilder = new IndexTemplateMapping.Builder().aliases(templateDescriptor.getAlias(), new Alias.Builder().build());
        try {
            JsonNode indexAsJSONNode = this.objectMapper.readTree((Reader)new StringReader(json));
            IndexSettings customSettings = this.getCustomSettings(templateSettings, indexAsJSONNode);
            TypeMapping mappings = this.getMappings(indexAsJSONNode.get(MAPPINGS));
            IndexTemplateMapping template = templateBuilder.mappings(mappings).settings(customSettings).build();
            PutIndexTemplateRequest request = new PutIndexTemplateRequest.Builder().name(templateDescriptor.getTemplateName()).indexPatterns(templateDescriptor.getIndexPattern(), new String[0]).template(template).composedOf(this.settingsTemplateName(), new String[0]).build();
            return request;
        }
        catch (Exception ex) {
            throw new TasklistRuntimeException((Throwable)ex);
        }
    }

    private TypeMapping getMappings(JsonNode mappingsAsJSON) {
        JsonbJsonpMapper jsonpMapper = new JsonbJsonpMapper();
        JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(mappingsAsJSON.toPrettyString()));
        return (TypeMapping)TypeMapping._DESERIALIZER.deserialize(jsonParser, (JsonpMapper)jsonpMapper);
    }

    public void createIndexLifeCyclesIfNotExist() {
        if (this.retryOpenSearchClient.getLifecyclePolicy(TASKLIST_DELETE_ARCHIVED_INDICES).isPresent()) {
            LOGGER.info("{} ISM policy already exists", (Object)TASKLIST_DELETE_ARCHIVED_INDICES);
            return;
        }
        LOGGER.info("Creating ISM Policy for deleting archived indices");
        Request request = new Request("PUT", "/_plugins/_ism/policies/tasklist_delete_archived_indices");
        JsonObject deleteJson = Json.createObjectBuilder().add("delete", (JsonValue)Json.createObjectBuilder().build()).build();
        JsonArray actionsDelete = Json.createArrayBuilder().add((JsonValue)deleteJson).build();
        JsonObject deleteState = Json.createObjectBuilder().add("name", (JsonValue)Json.createValue((String)"delete")).add("actions", (JsonValue)actionsDelete).build();
        JsonObject openCondition = Json.createObjectBuilder().add("min_index_age", (JsonValue)Json.createValue((String)this.tasklistProperties.getArchiver().getIlmMinAgeForDeleteArchivedIndices())).build();
        JsonObject openTransition = Json.createObjectBuilder().add("state_name", (JsonValue)Json.createValue((String)"delete")).add("conditions", (JsonValue)openCondition).build();
        JsonArray transitionOpenActions = Json.createArrayBuilder().add((JsonValue)openTransition).build();
        JsonObject openActionJson = Json.createObjectBuilder().add("open", (JsonValue)Json.createObjectBuilder().build()).build();
        JsonArray openActions = Json.createArrayBuilder().add((JsonValue)openActionJson).build();
        JsonObject openState = Json.createObjectBuilder().add("name", (JsonValue)Json.createValue((String)"open")).add("actions", (JsonValue)openActions).add("transitions", (JsonValue)transitionOpenActions).build();
        JsonArray statesJson = Json.createArrayBuilder().add((JsonValue)openState).add((JsonValue)deleteState).build();
        JsonObject policyJson = Json.createObjectBuilder().add("policy_id", (JsonValue)Json.createValue((String)TASKLIST_DELETE_ARCHIVED_INDICES)).add("description", (JsonValue)Json.createValue((String)"Policy to delete archived indices older than configuration")).add("default_state", (JsonValue)Json.createValue((String)"open")).add("states", (JsonValue)statesJson).build();
        JsonObject requestJson = Json.createObjectBuilder().add("policy", (JsonValue)policyJson).build();
        request.setJsonEntity(requestJson.toString());
        try {
            Response response = this.opensearchRestClient.performRequest(request);
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    private void createDefaults() {
        TasklistOpenSearchProperties elsConfig = this.tasklistProperties.getOpenSearch();
        String settingsTemplateName = this.settingsTemplateName();
        LOGGER.info("Create default settings '{}' with {} shards and {} replicas per index.", new Object[]{settingsTemplateName, elsConfig.getNumberOfShards(), elsConfig.getNumberOfReplicas()});
        IndexSettings settings = this.getIndexSettings();
        this.retryOpenSearchClient.createComponentTemplate(new PutComponentTemplateRequest.Builder().name(settingsTemplateName).template(t -> t.settings(settings)).build());
    }

    private IndexSettings getIndexSettings() {
        TasklistOpenSearchProperties osConfig = this.tasklistProperties.getOpenSearch();
        return new IndexSettings.Builder().numberOfShards(String.valueOf(osConfig.getNumberOfShards())).numberOfReplicas(String.valueOf(osConfig.getNumberOfReplicas())).build();
    }

    private String settingsTemplateName() {
        TasklistOpenSearchProperties osConfig = this.tasklistProperties.getOpenSearch();
        return String.format("%s_template", osConfig.getIndexPrefix());
    }

    private void createTemplates() {
        this.templateDescriptors.forEach(this::createTemplate);
    }

    private void createTemplate(TemplateDescriptor templateDescriptor) {
        IndexTemplateMapping template = this.getTemplateFrom(templateDescriptor);
        this.putIndexTemplate(new PutIndexTemplateRequest.Builder().indexPatterns(List.of(templateDescriptor.getIndexPattern())).template(template).name(templateDescriptor.getTemplateName()).composedOf(List.of(this.settingsTemplateName())).build());
        String indexName = templateDescriptor.getFullQualifiedName();
        this.createIndex(new CreateIndexRequest.Builder().index(indexName).build(), indexName);
    }

    private void putIndexTemplate(PutIndexTemplateRequest request, boolean overwrite) {
        boolean created = this.retryOpenSearchClient.createTemplate(request, overwrite);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }

    private void putIndexTemplate(PutIndexTemplateRequest request) {
        boolean created = this.retryOpenSearchClient.createTemplate(request);
        if (created) {
            LOGGER.debug("Template [{}] was successfully created", (Object)request.name());
        } else {
            LOGGER.debug("Template [{}] was NOT created", (Object)request.name());
        }
    }

    private IndexTemplateMapping getTemplateFrom(TemplateDescriptor templateDescriptor) {
        String templateFilename = String.format("/schema/os/create/template/tasklist-%s.json", templateDescriptor.getIndexName());
        InputStream templateConfig = OpenSearchSchemaManager.class.getResourceAsStream(templateFilename);
        JsonpMapper mapper = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper();
        JsonParser parser = mapper.jsonProvider().createParser(templateConfig);
        return new IndexTemplateMapping.Builder().mappings((TypeMapping)TypeMapping._DESERIALIZER.deserialize(parser, mapper)).aliases(templateDescriptor.getAlias(), new Alias.Builder().build()).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream readJSONFile(String filename) {
        try (InputStream inputStream = OpenSearchSchemaManager.class.getResourceAsStream(filename);){
            if (inputStream == null) throw new TasklistRuntimeException("Failed to find " + filename + " in classpath ");
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Failed to load file " + filename + " from classpath ", (Throwable)e);
        }
    }

    private void createIndex(CreateIndexRequest createIndexRequest, String indexName) {
        boolean created = this.retryOpenSearchClient.createIndex(createIndexRequest);
        if (created) {
            LOGGER.debug("Index [{}] was successfully created", (Object)indexName);
        } else {
            LOGGER.debug("Index [{}] was NOT created", (Object)indexName);
        }
    }

    private void createIndices() {
        this.indexDescriptors.forEach(this::createIndex);
    }

    private IndexSettings templateSettings(TemplateDescriptor indexDescriptor) {
        Integer shards = (Integer)this.tasklistProperties.getOpenSearch().getNumberOfShardsPerIndex().get(indexDescriptor.getIndexName());
        Integer replicas = (Integer)this.tasklistProperties.getOpenSearch().getNumberOfReplicasPerIndex().get(indexDescriptor.getIndexName());
        if (shards != null || replicas != null) {
            IndexSettings.Builder indexSettingsBuilder = new IndexSettings.Builder();
            if (shards != null) {
                indexSettingsBuilder.numberOfShards(shards.toString());
            }
            if (replicas != null) {
                indexSettingsBuilder.numberOfReplicas(replicas.toString());
            }
            return indexSettingsBuilder.build();
        }
        return null;
    }

    private IndexSettings getCustomSettings(IndexSettings defaultSettings, JsonNode indexAsJSONNode) {
        JsonbJsonpMapper jsonpMapper = new JsonbJsonpMapper();
        if (indexAsJSONNode.has(SETTINGS)) {
            JsonNode settingsJSON = indexAsJSONNode.get(SETTINGS);
            JsonParser jsonParser = JsonProvider.provider().createParser((Reader)new StringReader(settingsJSON.toPrettyString()));
            IndexSettings updatedSettings = (IndexSettings)IndexSettings._DESERIALIZER.deserialize(jsonParser, (JsonpMapper)jsonpMapper);
            return new IndexSettings.Builder().index(defaultSettings).analysis(updatedSettings.analysis()).build();
        }
        return defaultSettings;
    }

    private static String readTemplateJson(String classPathResourceName) {
        try {
            InputStream description = OpenSearchSchemaManager.class.getResourceAsStream(classPathResourceName);
            String json = StreamUtils.copyToString((InputStream)description, (Charset)StandardCharsets.UTF_8);
            return json;
        }
        catch (Exception e) {
            throw new TasklistRuntimeException("Exception occurred when reading template JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

