/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import io.camunda.tasklist.schema.IndexMapping;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IndexMappingDifference {
    private boolean equal;
    private Set<IndexMapping.IndexMappingProperty> entriesOnlyOnLeft;
    private Set<IndexMapping.IndexMappingProperty> entriesOnlyOnRight;
    private Set<IndexMapping.IndexMappingProperty> entriesInCommon;
    private Set<PropertyDifference> entriesDiffering;
    private IndexMapping leftIndexMapping;
    private IndexMapping rightIndexMapping;

    public boolean isEqual() {
        return this.equal;
    }

    public IndexMappingDifference setEqual(boolean equal) {
        this.equal = equal;
        return this;
    }

    public Set<IndexMapping.IndexMappingProperty> getEntriesOnlyOnLeft() {
        return this.entriesOnlyOnLeft;
    }

    public IndexMappingDifference setEntriesOnlyOnLeft(Set<IndexMapping.IndexMappingProperty> entriesOnlyOnLeft) {
        this.entriesOnlyOnLeft = entriesOnlyOnLeft;
        return this;
    }

    public Set<IndexMapping.IndexMappingProperty> getEntriesOnlyOnRight() {
        return this.entriesOnlyOnRight;
    }

    public IndexMappingDifference setEntriesOnlyOnRight(Set<IndexMapping.IndexMappingProperty> entriesOnlyOnRight) {
        this.entriesOnlyOnRight = entriesOnlyOnRight;
        return this;
    }

    public Set<IndexMapping.IndexMappingProperty> getEntriesInCommon() {
        return this.entriesInCommon;
    }

    public IndexMappingDifference setEntriesInCommon(Set<IndexMapping.IndexMappingProperty> entriesInCommon) {
        this.entriesInCommon = entriesInCommon;
        return this;
    }

    public Set<PropertyDifference> getEntriesDiffering() {
        return this.entriesDiffering;
    }

    public IndexMappingDifference setEntriesDiffering(Set<PropertyDifference> entriesDiffering) {
        this.entriesDiffering = entriesDiffering;
        return this;
    }

    public IndexMapping getLeftIndexMapping() {
        return this.leftIndexMapping;
    }

    public IndexMappingDifference setLeftIndexMapping(IndexMapping leftIndexMapping) {
        this.leftIndexMapping = leftIndexMapping;
        return this;
    }

    public IndexMapping getRightIndexMapping() {
        return this.rightIndexMapping;
    }

    public IndexMappingDifference setRightIndexMapping(IndexMapping rightIndexMapping) {
        this.rightIndexMapping = rightIndexMapping;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.equal, this.entriesOnlyOnLeft, this.entriesOnlyOnRight, this.entriesInCommon, this.entriesDiffering, this.leftIndexMapping, this.rightIndexMapping);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMappingDifference that = (IndexMappingDifference)o;
        return this.equal == that.equal && Objects.equals(this.entriesOnlyOnLeft, that.entriesOnlyOnLeft) && Objects.equals(this.entriesOnlyOnRight, that.entriesOnlyOnRight) && Objects.equals(this.entriesInCommon, that.entriesInCommon) && Objects.equals(this.entriesDiffering, that.entriesDiffering) && Objects.equals(this.leftIndexMapping, that.leftIndexMapping) && Objects.equals(this.rightIndexMapping, that.rightIndexMapping);
    }

    public String toString() {
        return "IndexMappingDifference{equal=" + this.equal + ", entriesOnlyOnLeft=" + String.valueOf(this.entriesOnlyOnLeft) + ", entriesOnlyOnRight=" + String.valueOf(this.entriesOnlyOnRight) + ", entriesInCommon=" + String.valueOf(this.entriesInCommon) + ", entriesDiffering=" + String.valueOf(this.entriesDiffering) + ", leftIndexMapping=" + String.valueOf(this.leftIndexMapping) + ", rightIndexMapping=" + String.valueOf(this.rightIndexMapping) + "}";
    }

    public boolean checkEqualityForDifferences(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMappingDifference that = (IndexMappingDifference)o;
        return this.equal == that.equal && Objects.equals(this.entriesOnlyOnLeft, that.entriesOnlyOnLeft) && Objects.equals(this.entriesOnlyOnRight, that.entriesOnlyOnRight) && Objects.equals(this.entriesInCommon, that.entriesInCommon) && Objects.equals(this.entriesDiffering, that.entriesDiffering);
    }

    public static class PropertyDifference {
        private String name;
        private IndexMapping.IndexMappingProperty leftValue;
        private IndexMapping.IndexMappingProperty rightValue;

        public String getName() {
            return this.name;
        }

        public PropertyDifference setName(String name) {
            this.name = name;
            return this;
        }

        public IndexMapping.IndexMappingProperty getLeftValue() {
            return this.leftValue;
        }

        public PropertyDifference setLeftValue(IndexMapping.IndexMappingProperty leftValue) {
            this.leftValue = leftValue;
            return this;
        }

        public IndexMapping.IndexMappingProperty getRightValue() {
            return this.rightValue;
        }

        public PropertyDifference setRightValue(IndexMapping.IndexMappingProperty rightValue) {
            this.rightValue = rightValue;
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.leftValue, this.rightValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyDifference that = (PropertyDifference)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.leftValue, that.leftValue) && Objects.equals(this.rightValue, that.rightValue);
        }

        public String toString() {
            return "PropertyDifference{name='" + this.name + "', leftValue=" + String.valueOf(this.leftValue) + ", rightValue=" + String.valueOf(this.rightValue) + "}";
        }
    }

    public static class IndexMappingDifferenceBuilder {
        private IndexMapping left;
        private IndexMapping right;

        public static IndexMappingDifferenceBuilder builder() {
            return new IndexMappingDifferenceBuilder();
        }

        public IndexMappingDifferenceBuilder setLeft(IndexMapping left) {
            this.left = left;
            return this;
        }

        public IndexMappingDifferenceBuilder setRight(IndexMapping right) {
            this.right = right;
            return this;
        }

        public IndexMappingDifference build() {
            Map leftMap = this.left == null ? Map.of() : this.left.toMap();
            Map rightMap = this.right == null ? Map.of() : this.right.toMap();
            MapDifference difference = Maps.difference(leftMap, rightMap);
            return new IndexMappingDifference().setEqual(difference.areEqual()).setLeftIndexMapping(this.left).setRightIndexMapping(this.right).setEntriesOnlyOnLeft(difference.entriesOnlyOnLeft().entrySet().stream().map(p -> IndexMapping.IndexMappingProperty.createIndexMappingProperty(p)).collect(Collectors.toSet())).setEntriesOnlyOnRight(difference.entriesOnlyOnRight().entrySet().stream().map(p -> IndexMapping.IndexMappingProperty.createIndexMappingProperty(p)).collect(Collectors.toSet())).setEntriesInCommon(difference.entriesInCommon().entrySet().stream().map(p -> IndexMapping.IndexMappingProperty.createIndexMappingProperty(p)).collect(Collectors.toSet())).setEntriesDiffering(difference.entriesDiffering().entrySet().stream().map(entry -> new PropertyDifference().setName((String)entry.getKey()).setLeftValue(new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(((MapDifference.ValueDifference)entry.getValue()).leftValue())).setRightValue(new IndexMapping.IndexMappingProperty().setName((String)entry.getKey()).setTypeDefinition(((MapDifference.ValueDifference)entry.getValue()).rightValue()))).collect(Collectors.toSet()));
        }
    }
}

