/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.MetricEntity;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.MetricIndex;
import io.camunda.tasklist.store.TaskMetricsStore;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch._types.ExpandWildcard;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.Result;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.StringTermsBucket;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.IndexResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@Conditional(value={OpenSearchCondition.class})
public class TaskMetricsStoreOpenSearch
implements TaskMetricsStore {
    public static final String EVENT_TASK_COMPLETED_BY_ASSIGNEE = "task_completed_by_assignee";
    public static final String ASSIGNEE = "assignee";
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskMetricsStoreOpenSearch.class);
    @Autowired
    private MetricIndex index;
    @Autowired
    @Qualifier(value="tasklistOsClient")
    private OpenSearchClient openSearchClient;

    @Override
    public void registerTaskCompleteEvent(TaskEntity task) {
        MetricEntity metric = this.createTaskCompleteEvent(task);
        boolean inserted = this.insert(metric);
        if (!inserted) {
            String message = "Wrong response status while logging event";
            LOGGER.error("Wrong response status while logging event");
            throw new TasklistRuntimeException("Wrong response status while logging event");
        }
    }

    private boolean insert(MetricEntity entity) {
        try {
            IndexRequest request = IndexRequest.of(builder -> builder.index(this.index.getFullQualifiedName()).id(entity.getId()).document((Object)entity));
            IndexResponse response = this.openSearchClient.index(request);
            return Result.Created.equals((Object)response.result());
        }
        catch (IOException | OpenSearchException e) {
            LOGGER.error(e.getMessage(), e);
            throw new TasklistRuntimeException("Error while trying to upsert entity: " + String.valueOf(entity));
        }
    }

    @Override
    public List<String> retrieveDistinctAssigneesBetweenDates(OffsetDateTime startTime, OffsetDateTime endTime) {
        Query rangeQuery = OpenSearchUtil.joinWithAnd(new Query.Builder().term(t -> t.field("event").value(FieldValue.of((String)EVENT_TASK_COMPLETED_BY_ASSIGNEE))), new Query.Builder().range(r -> {
            r.field("eventTime");
            if (startTime != null) {
                r.gte(JsonData.of((Object)startTime));
            }
            if (endTime != null) {
                r.lte(JsonData.of((Object)endTime));
            }
            return r;
        }));
        SearchRequest searchRequest = new SearchRequest.Builder().allowNoIndices(Boolean.valueOf(true)).ignoreUnavailable(Boolean.valueOf(true)).expandWildcards(ExpandWildcard.Open, new ExpandWildcard[0]).index(this.index.getFullQualifiedName(), new String[0]).query(rangeQuery).aggregations(ASSIGNEE, agg -> agg.terms(ta -> ta.field("value").size(Integer.valueOf(Integer.MAX_VALUE)))).build();
        try {
            SearchResponse response = this.openSearchClient.search(searchRequest, Void.class);
            Map aggregations = response.aggregations();
            if (CollectionUtils.isEmpty((Map)aggregations)) {
                throw new TasklistRuntimeException("Search with aggregation returned no aggregation");
            }
            Aggregate aggregate = (Aggregate)aggregations.get(ASSIGNEE);
            if (!aggregate.isSterms()) {
                throw new TasklistRuntimeException("Unexpected response for aggregations");
            }
            List buckets = aggregate.sterms().buckets().array();
            return buckets.stream().map(StringTermsBucket::key).toList();
        }
        catch (IOException | OpenSearchException e) {
            LOGGER.error("Error while retrieving assigned users between dates from index: " + String.valueOf(this.index), e);
            String message = "Error while retrieving assigned users between dates";
            throw new TasklistRuntimeException("Error while retrieving assigned users between dates");
        }
    }

    private MetricEntity createTaskCompleteEvent(TaskEntity task) {
        return (MetricEntity)new MetricEntity().setEvent(EVENT_TASK_COMPLETED_BY_ASSIGNEE).setValue(task.getAssignee()).setEventTime(task.getCompletionTime()).setTenantId(task.getTenantId());
    }
}

