/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.opensearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.tenant.TenantAwareOpenSearchClient;
import io.camunda.tasklist.util.OpenSearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldSort;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.OpenSearchException;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.aggregations.Aggregate;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationBuilders;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregate;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregation;
import org.opensearch.client.opensearch._types.aggregations.CompositeAggregationSource;
import org.opensearch.client.opensearch._types.aggregations.FilterAggregate;
import org.opensearch.client.opensearch._types.aggregations.LongTermsAggregate;
import org.opensearch.client.opensearch._types.aggregations.TermsAggregation;
import org.opensearch.client.opensearch._types.aggregations.TopHitsAggregate;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.QueryBuilders;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.FieldCollapse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ProcessStoreOpenSearch
implements ProcessStore {
    private static final Boolean CASE_INSENSITIVE = true;
    private static final String BPMN_PROCESS_ID_TENANT_ID_AGG_NAME = "bpmnProcessId_tenantId_buckets";
    private static final String TOP_HITS_AGG_NAME = "top_hit_doc";
    private static final String DEFINITION_ID_TERMS_SOURCE_NAME = "group_by_definition_id";
    private static final String TENANT_ID_TERMS_SOURCE_NAME = "group_by_tenant_id";
    private static final String MAX_VERSION_DOCUMENTS_AGG_NAME = "max_version_docs";
    private static final String STARTED_BY_FORM_FILTERED_DOCS = "started_by_form_docs";
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    private TenantAwareOpenSearchClient tenantAwareClient;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public ProcessEntity getProcessByProcessDefinitionKey(String processDefinitionKey) {
        try {
            FieldCollapse keyCollapse = new FieldCollapse.Builder().field("key").build();
            SortOptions sortOptions = (SortOptions)new SortOptions.Builder().field(FieldSort.of(f -> f.field("version").order(SortOrder.Desc))).build();
            SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(List.of(this.processIndex.getAlias())).query(q -> q.term(t -> t.field("key").value(FieldValue.of((String)processDefinitionKey)))).collapse(keyCollapse).sort(sortOptions, new SortOptions[0]).size(Integer.valueOf(1));
            SearchResponse response = this.tenantAwareClient.search(searchRequestBuilder, ProcessEntity.class);
            if (!response.hits().hits().isEmpty()) {
                return (ProcessEntity)((Hit)response.hits().hits().getFirst()).source();
            }
            throw new NotFoundException(String.format("Process with key %s not found", processDefinitionKey));
        }
        catch (IOException | OpenSearchException e) {
            throw new TasklistRuntimeException(e);
        }
    }

    @Override
    public ProcessEntity getProcessByBpmnProcessId(String bpmnProcessId) {
        return this.getProcessByBpmnProcessId(bpmnProcessId, null);
    }

    @Override
    public ProcessEntity getProcessByBpmnProcessId(String bpmnProcessId, String tenantId) {
        FieldCollapse keyCollapse = new FieldCollapse.Builder().field("bpmnProcessId").build();
        SortOptions sortOptions = (SortOptions)new SortOptions.Builder().field(FieldSort.of(f -> f.field("version").order(SortOrder.Desc))).build();
        Query functionQuery = (Query)new Query.Builder().term(term -> term.field("bpmnProcessId").value(FieldValue.of((String)bpmnProcessId))).build();
        Query qb = this.tasklistProperties.getMultiTenancy().isEnabled() && StringUtils.isNotBlank((CharSequence)tenantId) ? OpenSearchUtil.joinWithAnd((Query)new Query.Builder().term(term -> term.field("tenantId").value(FieldValue.of((String)tenantId))).build(), functionQuery) : functionQuery;
        SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(List.of(this.processIndex.getAlias())).query(qb).collapse(keyCollapse).sort(sortOptions, new SortOptions[0]).size(Integer.valueOf(1));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequestBuilder, ProcessEntity.class);
            if (!response.hits().hits().isEmpty()) {
                return (ProcessEntity)((Hit)response.hits().hits().getFirst()).source();
            }
            throw new NotFoundException(String.format("Could not find process with id '%s'.", bpmnProcessId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public ProcessEntity getProcess(String processId) {
        try {
            SearchRequest.Builder searchRequestBuilder = new SearchRequest.Builder().index(List.of(this.processIndex.getAlias())).query(q -> q.term(t -> t.field("key").value(FieldValue.of((String)processId))));
            SearchResponse response = this.tenantAwareClient.search(searchRequestBuilder, ProcessEntity.class);
            long totalHits = response.hits().total().value();
            if (totalHits == 1L) {
                return (ProcessEntity)((Hit)response.hits().hits().getFirst()).source();
            }
            if (totalHits > 1L) {
                throw new TasklistRuntimeException(String.format("Could not find unique process with id '%s'.", processId));
            }
            throw new NotFoundException(String.format("Could not find process with id '%s'.", processId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<ProcessEntity> getProcesses(List<String> processDefinitions, String tenantId, Boolean isStartedByForm) {
        Query q;
        if (this.tasklistProperties.isSelfManaged()) {
            if (processDefinitions.isEmpty()) {
                return new ArrayList<ProcessEntity>();
            }
            q = processDefinitions.contains("*") ? QueryBuilders.bool().must(t -> t.exists(e -> e.field("bpmnProcessId"))).mustNot(mn -> mn.term(t -> t.field("bpmnProcessId").value(FieldValue.of((String)"")))).build().toQuery() : QueryBuilders.bool().must(m -> m.terms(terms -> terms.field("bpmnProcessId").terms(v -> v.value(processDefinitions.stream().map(FieldValue::of).collect(Collectors.toList()))))).must(m -> m.exists(e -> e.field("bpmnProcessId"))).mustNot(mn -> mn.term(t -> t.field("bpmnProcessId").value(FieldValue.of((String)"")))).build().toQuery();
        } else {
            q = QueryBuilders.bool().must(m -> m.exists(e -> e.field("bpmnProcessId"))).mustNot(mn -> mn.term(t -> t.field("bpmnProcessId").value(FieldValue.of((String)"")))).build().toQuery();
        }
        Query applyTenantIdFilter = this.addFilterOnTenantIdIfRequired(q, tenantId);
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId(applyTenantIdFilter, isStartedByForm);
    }

    @Override
    public List<ProcessEntity> getProcesses(String search, List<String> processDefinitions, String tenantId, Boolean isStartedByForm) {
        if (search == null || search.isBlank()) {
            return this.getProcesses(processDefinitions, tenantId, isStartedByForm);
        }
        String regexSearch = String.format(".*%s.*", search);
        BoolQuery.Builder query = QueryBuilders.bool().should(s -> s.term(t -> t.field("id").value(FieldValue.of((String)search)))).should(s -> s.regexp(regex -> regex.field("name").caseInsensitive(CASE_INSENSITIVE).value(regexSearch))).should(s -> s.regexp(regex -> regex.field("bpmnProcessId").caseInsensitive(CASE_INSENSITIVE).value(regexSearch))).must(m -> m.exists(e -> e.field("bpmnProcessId"))).mustNot(mn -> mn.term(t -> t.field("bpmnProcessId").value(FieldValue.of((String)"")))).minimumShouldMatch("1");
        if (this.tasklistProperties.getIdentity().isResourcePermissionsEnabled()) {
            if (processDefinitions.isEmpty()) {
                return new ArrayList<ProcessEntity>();
            }
            if (!processDefinitions.contains("*")) {
                query.must(m -> m.terms(terms -> terms.field("bpmnProcessId").terms(v -> v.value(processDefinitions.stream().map(FieldValue::of).collect(Collectors.toList())))));
            }
        }
        Query applyTenantIdFilter = this.addFilterOnTenantIdIfRequired(query.build().toQuery(), tenantId);
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId(applyTenantIdFilter, isStartedByForm);
    }

    @Override
    public List<ProcessEntity> getProcessesStartedByForm() {
        Query query = QueryBuilders.bool().must(m -> m.exists(e -> e.field("bpmnProcessId"))).mustNot(mn -> mn.term(t -> t.field("bpmnProcessId").value(FieldValue.of((String)"")))).build().toQuery();
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId(query, true);
    }

    private Query addFilterOnTenantIdIfRequired(Query query, String tenantId) {
        if (this.tasklistProperties.getMultiTenancy().isEnabled() && StringUtils.isNotBlank((CharSequence)tenantId)) {
            Query tenantQuery = (Query)new Query.Builder().term(term -> term.field("tenantId").value(FieldValue.of((String)tenantId))).build();
            return OpenSearchUtil.joinWithAnd(tenantQuery, query);
        }
        return query;
    }

    private List<ProcessEntity> getProcessEntityUniqueByProcessDefinitionIdAndTenantId(Query query, Boolean isStartedByForm) {
        CompositeAggregation.Builder processDefinitionAndTenantBucket = new CompositeAggregation.Builder().sources(List.of(Map.of(DEFINITION_ID_TERMS_SOURCE_NAME, new CompositeAggregationSource.Builder().terms(t -> t.field("bpmnProcessId")).build()), Map.of(TENANT_ID_TERMS_SOURCE_NAME, new CompositeAggregationSource.Builder().terms(t -> t.field("tenantId")).build()))).size(Integer.valueOf(10000));
        TermsAggregation maxVersionDocTerm = new TermsAggregation.Builder().field("version").order(Map.of("_key", SortOrder.Desc), new Map[0]).size(Integer.valueOf(1)).build();
        Aggregation topHitsAgg = AggregationBuilders.topHits().sort(SortOptions.of(s -> s.field(f -> f.field("version").order(SortOrder.Desc))), new SortOptions[0]).size(Integer.valueOf(1)).build()._toAggregation();
        SearchRequest.Builder searchRequest = new SearchRequest.Builder().index(this.processIndex.getAlias(), new String[0]).query(query).size(Integer.valueOf(0));
        if (isStartedByForm == null) {
            Aggregation nestedAggregate = new Aggregation.Builder().terms(maxVersionDocTerm).aggregations(TOP_HITS_AGG_NAME, topHitsAgg).build();
            searchRequest.aggregations(BPMN_PROCESS_ID_TENANT_ID_AGG_NAME, Aggregation.of(agg -> agg.composite(processDefinitionAndTenantBucket.build()).aggregations(MAX_VERSION_DOCUMENTS_AGG_NAME, nestedAggregate)));
        } else {
            Query startedByFormFilter = this.startedByFormAggregateFilter(isStartedByForm);
            Aggregation filterAggregate = new Aggregation.Builder().filter(startedByFormFilter).aggregations(TOP_HITS_AGG_NAME, topHitsAgg).build();
            Aggregation maxVersionAggregate = new Aggregation.Builder().terms(maxVersionDocTerm).aggregations(STARTED_BY_FORM_FILTERED_DOCS, filterAggregate).build();
            searchRequest.aggregations(BPMN_PROCESS_ID_TENANT_ID_AGG_NAME, Aggregation.of(agg -> agg.composite(processDefinitionAndTenantBucket.build()).aggregations(MAX_VERSION_DOCUMENTS_AGG_NAME, maxVersionAggregate)));
        }
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest, ProcessEntity.class);
            CompositeAggregate composite = ((Aggregate)response.aggregations().get(BPMN_PROCESS_ID_TENANT_ID_AGG_NAME)).composite();
            List<Hit<JsonData>> hits = isStartedByForm != null ? this.getFilteredAggregateSearchHits(composite) : this.getAggregateSearchHits(composite);
            return OpenSearchUtil.mapSearchHits(hits, this.objectMapper, ProcessEntity.class);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private List<Hit<JsonData>> getFilteredAggregateSearchHits(CompositeAggregate composite) {
        return composite.buckets().array().stream().flatMap(bucket -> ((LongTermsAggregate)((Aggregate)bucket.aggregations().get(MAX_VERSION_DOCUMENTS_AGG_NAME))._get()).buckets().array().stream().flatMap(versionBucket -> {
            Map startedByFormDocs = ((FilterAggregate)((Aggregate)versionBucket.aggregations().get(STARTED_BY_FORM_FILTERED_DOCS))._get()).aggregations();
            return ((TopHitsAggregate)((Aggregate)startedByFormDocs.get(TOP_HITS_AGG_NAME))._get()).hits().hits().stream();
        })).collect(Collectors.toList());
    }

    private List<Hit<JsonData>> getAggregateSearchHits(CompositeAggregate composite) {
        return composite.buckets().array().stream().flatMap(bucket -> ((LongTermsAggregate)((Aggregate)bucket.aggregations().get(MAX_VERSION_DOCUMENTS_AGG_NAME))._get()).buckets().array().stream().flatMap(versionBucket -> ((TopHitsAggregate)((Aggregate)versionBucket.aggregations().get(TOP_HITS_AGG_NAME))._get()).hits().hits().stream())).collect(Collectors.toList());
    }

    private Query startedByFormAggregateFilter(boolean isStartedByForm) {
        BoolQuery.Builder boolQueryBuilder = QueryBuilders.bool();
        if (isStartedByForm) {
            boolQueryBuilder.should(QueryBuilders.exists().field("formKey").build().toQuery(), new Query[0]).should(QueryBuilders.exists().field("formId").build().toQuery(), new Query[0]).minimumShouldMatch("1");
        } else {
            boolQueryBuilder.mustNot(QueryBuilders.exists().field("formKey").build().toQuery(), new Query[0]).mustNot(QueryBuilders.exists().field("formId").build().toQuery(), new Query[0]).minimumShouldMatch("1");
        }
        return boolQueryBuilder.build().toQuery();
    }
}

