/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.exceptions.NotFoundException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.ProcessIndex;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.tenant.TenantAwareElasticsearchClient;
import io.camunda.tasklist.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.composite.TermsValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.aggregations.metrics.TopHitsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.collapse.CollapseBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ProcessStoreElasticSearch
implements ProcessStore {
    private static final Boolean CASE_INSENSITIVE = true;
    private static final String BPMN_PROCESS_ID_TENANT_ID_AGG_NAME = "bpmnProcessId_tenantId_buckets";
    private static final String TOP_HITS_AGG_NAME = "top_hit_doc";
    private static final String DEFINITION_ID_TERMS_SOURCE_NAME = "group_by_definition_id";
    private static final String TENANT_ID_TERMS_SOURCE_NAME = "group_by_tenant_id";
    private static final String MAX_VERSION_DOCUMENTS_AGG_NAME = "max_version_docs";
    private static final String STARTED_BY_FORM_FILTERED_DOCS = "started_by_form_docs";
    @Autowired
    private ProcessIndex processIndex;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;

    @Override
    public ProcessEntity getProcessByProcessDefinitionKey(String processDefinitionKey) {
        TermQueryBuilder qb = QueryBuilders.termQuery((String)"key", (String)processDefinitionKey);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)qb).collapse(new CollapseBuilder("key")).sort(SortBuilders.fieldSort((String)"version").order(SortOrder.DESC)).size(1));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value > 0L) {
                ProcessEntity processEntity = this.fromSearchHit(response.getHits().getHits()[0].getSourceAsString());
                return processEntity;
            }
            throw new NotFoundException(String.format("Process with key %s not found", processDefinitionKey));
        }
        catch (IOException e) {
            throw new TasklistRuntimeException((Throwable)e);
        }
    }

    @Override
    public ProcessEntity getProcessByBpmnProcessId(String bpmnProcessId) {
        return this.getProcessByBpmnProcessId(bpmnProcessId, null);
    }

    @Override
    public ProcessEntity getProcessByBpmnProcessId(String bpmnProcessId, String tenantId) {
        Object qb = this.tasklistProperties.getMultiTenancy().isEnabled() && StringUtils.isNotBlank((CharSequence)tenantId) ? ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"bpmnProcessId", (String)bpmnProcessId), QueryBuilders.termQuery((String)"tenantId", (String)tenantId)}) : QueryBuilders.termQuery((String)"bpmnProcessId", (String)bpmnProcessId);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)qb).collapse(new CollapseBuilder("bpmnProcessId")).sort(SortBuilders.fieldSort((String)"version").order(SortOrder.DESC)).size(1));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value > 0L) {
                ProcessEntity processEntity = this.fromSearchHit(response.getHits().getHits()[0].getSourceAsString());
                return processEntity;
            }
            throw new NotFoundException(String.format("Could not find process with id '%s'.", bpmnProcessId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public ProcessEntity getProcess(String processId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (String)processId)));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                return this.fromSearchHit(response.getHits().getHits()[0].getSourceAsString());
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new TasklistRuntimeException(String.format("Could not find unique process with id '%s'.", processId));
            }
            throw new NotFoundException(String.format("Could not find process with id '%s'.", processId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<ProcessEntity> getProcesses(List<String> processDefinitions, String tenantId, Boolean isStartedByForm) {
        BoolQueryBuilder qb;
        if (this.tasklistProperties.getIdentity().isResourcePermissionsEnabled()) {
            if (processDefinitions.isEmpty()) {
                return new ArrayList<ProcessEntity>();
            }
            qb = processDefinitions.contains("*") ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"bpmnProcessId")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"bpmnProcessId", (String)"")) : QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)"bpmnProcessId", processDefinitions)).must((QueryBuilder)QueryBuilders.existsQuery((String)"bpmnProcessId")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"bpmnProcessId", (String)""));
        } else {
            qb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"bpmnProcessId")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"bpmnProcessId", (String)""));
        }
        QueryBuilder finalQuery = this.enhanceQueryByTenantIdCheck((QueryBuilder)qb, tenantId);
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId(finalQuery, isStartedByForm);
    }

    @Override
    public List<ProcessEntity> getProcesses(String search, List<String> processDefinitions, String tenantId, Boolean isStartedByForm) {
        if (StringUtils.isBlank((CharSequence)search)) {
            return this.getProcesses(processDefinitions, tenantId, isStartedByForm);
        }
        String regexSearch = String.format(".*%s.*", search);
        BoolQueryBuilder qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)"id", (String)search)).should((QueryBuilder)QueryBuilders.regexpQuery((String)"name", (String)regexSearch).caseInsensitive(CASE_INSENSITIVE.booleanValue())).should((QueryBuilder)QueryBuilders.regexpQuery((String)"bpmnProcessId", (String)regexSearch).caseInsensitive(CASE_INSENSITIVE.booleanValue())).must((QueryBuilder)QueryBuilders.existsQuery((String)"bpmnProcessId")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"bpmnProcessId", (String)"")).minimumShouldMatch(1);
        if (this.tasklistProperties.getIdentity().isResourcePermissionsEnabled()) {
            if (processDefinitions.isEmpty()) {
                return new ArrayList<ProcessEntity>();
            }
            if (!processDefinitions.contains("*")) {
                qb = qb.must((QueryBuilder)QueryBuilders.termsQuery((String)"bpmnProcessId", processDefinitions));
            }
        }
        QueryBuilder finalQuery = this.enhanceQueryByTenantIdCheck((QueryBuilder)qb, tenantId);
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId(finalQuery, isStartedByForm);
    }

    @Override
    public List<ProcessEntity> getProcessesStartedByForm() {
        BoolQueryBuilder qb = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.existsQuery((String)"bpmnProcessId")).mustNot((QueryBuilder)QueryBuilders.termQuery((String)"bpmnProcessId", (String)""));
        return this.getProcessEntityUniqueByProcessDefinitionIdAndTenantId((QueryBuilder)qb, true);
    }

    private ProcessEntity fromSearchHit(String processString) {
        return ElasticsearchUtil.fromSearchHit(processString, this.objectMapper, ProcessEntity.class);
    }

    private QueryBuilder enhanceQueryByTenantIdCheck(QueryBuilder qb, String tenantId) {
        if (this.tasklistProperties.getMultiTenancy().isEnabled() && StringUtils.isNotBlank((CharSequence)tenantId)) {
            return ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"tenantId", (String)tenantId), qb});
        }
        return qb;
    }

    public List<ProcessEntity> getProcessEntityUniqueByProcessDefinitionIdAndTenantId(QueryBuilder qb, Boolean isStartedByForm) {
        CompositeAggregationBuilder processDefinitionAndTenantBucket = AggregationBuilders.composite((String)BPMN_PROCESS_ID_TENANT_ID_AGG_NAME, List.of(new TermsValuesSourceBuilder(DEFINITION_ID_TERMS_SOURCE_NAME).field("bpmnProcessId"), new TermsValuesSourceBuilder(TENANT_ID_TERMS_SOURCE_NAME).field("tenantId"))).size(10000);
        TermsAggregationBuilder maxVersionDocsAggregate = ((TermsAggregationBuilder)AggregationBuilders.terms((String)MAX_VERSION_DOCUMENTS_AGG_NAME).field("version")).order(BucketOrder.key((boolean)false)).size(1);
        TopHitsAggregationBuilder topHitsAggregate = AggregationBuilders.topHits((String)TOP_HITS_AGG_NAME).sort(SortBuilders.fieldSort((String)"version").order(SortOrder.DESC)).size(1);
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query(qb).size(0);
        if (isStartedByForm == null) {
            sourceBuilder.aggregation((AggregationBuilder)processDefinitionAndTenantBucket.subAggregation(maxVersionDocsAggregate.subAggregation((AggregationBuilder)topHitsAggregate)));
        } else {
            sourceBuilder.aggregation((AggregationBuilder)processDefinitionAndTenantBucket.subAggregation(maxVersionDocsAggregate.subAggregation((AggregationBuilder)this.startedByFormAggregateFilter(isStartedByForm).subAggregation((AggregationBuilder)topHitsAggregate))));
        }
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processIndex.getAlias()}).source(sourceBuilder);
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            CompositeAggregation compositeAgg = (CompositeAggregation)response.getAggregations().get(BPMN_PROCESS_ID_TENANT_ID_AGG_NAME);
            Set<SearchHit> hits = isStartedByForm != null ? this.getFilteredAggregateSearchHits(compositeAgg) : this.getAggregateSearchHits(compositeAgg);
            return hits.stream().map(hit -> ElasticsearchUtil.fromSearchHit(hit.getSourceAsString(), this.objectMapper, ProcessEntity.class)).toList();
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the process: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private FilterAggregationBuilder startedByFormAggregateFilter(boolean isStartedByForm) {
        return isStartedByForm ? AggregationBuilders.filter((String)STARTED_BY_FORM_FILTERED_DOCS, (QueryBuilder)QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)"formKey")).should((QueryBuilder)QueryBuilders.existsQuery((String)"formId")).minimumShouldMatch(1)) : AggregationBuilders.filter((String)STARTED_BY_FORM_FILTERED_DOCS, (QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"formKey")).mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"formId")).minimumShouldMatch(1));
    }

    private Set<SearchHit> getFilteredAggregateSearchHits(CompositeAggregation composite) {
        return composite.getBuckets().stream().flatMap(bucket -> ((ParsedTerms)bucket.getAggregations().asMap().get(MAX_VERSION_DOCUMENTS_AGG_NAME)).getBuckets().stream().flatMap(versionBucket -> {
            Aggregations startedByFormDocs = ((Filter)versionBucket.getAggregations().get(STARTED_BY_FORM_FILTERED_DOCS)).getAggregations();
            return Arrays.stream(((TopHits)startedByFormDocs.get(TOP_HITS_AGG_NAME)).getHits().getHits());
        })).collect(Collectors.toSet());
    }

    private Set<SearchHit> getAggregateSearchHits(CompositeAggregation composite) {
        return composite.getBuckets().stream().flatMap(bucket -> ((ParsedTerms)bucket.getAggregations().get(MAX_VERSION_DOCUMENTS_AGG_NAME)).getBuckets().stream().flatMap(versionBucket -> Arrays.stream(((TopHits)versionBucket.getAggregations().get(TOP_HITS_AGG_NAME)).getHits().getHits()))).collect(Collectors.toSet());
    }
}

