/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.store;

import io.camunda.tasklist.entities.FlowNodeInstanceEntity;
import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.entities.TaskVariableEntity;
import io.camunda.tasklist.entities.VariableEntity;
import io.camunda.tasklist.views.TaskSearchView;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public interface VariableStore {
    public List<VariableEntity> getVariablesByFlowNodeInstanceIds(List<String> var1, List<String> var2, Set<String> var3);

    public Map<String, List<TaskVariableEntity>> getTaskVariablesPerTaskId(List<GetVariablesRequest> var1);

    public Map<String, String> getTaskVariablesIdsWithIndexByTaskIds(List<String> var1);

    public void persistTaskVariables(Collection<TaskVariableEntity> var1);

    public List<FlowNodeInstanceEntity> getFlowNodeInstances(List<String> var1);

    public VariableEntity getRuntimeVariable(String var1, Set<String> var2);

    public TaskVariableEntity getTaskVariable(String var1, Set<String> var2);

    public List<String> getProcessInstanceIdsWithMatchingVars(List<String> var1, List<String> var2);

    public static class GetVariablesRequest {
        private String taskId;
        private TaskState state;
        private String flowNodeInstanceId;
        private String processInstanceId;
        private List<String> varNames;
        private Set<String> fieldNames = new HashSet<String>();

        public static GetVariablesRequest createFrom(TaskEntity taskEntity, Set<String> fieldNames) {
            return new GetVariablesRequest().setTaskId(taskEntity.getId()).setFlowNodeInstanceId(taskEntity.getFlowNodeInstanceId()).setState(taskEntity.getState()).setProcessInstanceId(taskEntity.getProcessInstanceId()).setFieldNames(fieldNames);
        }

        public static GetVariablesRequest createFrom(TaskEntity taskEntity) {
            return new GetVariablesRequest().setTaskId(taskEntity.getId()).setFlowNodeInstanceId(taskEntity.getFlowNodeInstanceId()).setState(taskEntity.getState()).setProcessInstanceId(taskEntity.getProcessInstanceId());
        }

        public static GetVariablesRequest createFrom(TaskSearchView taskSearchView, List<String> varNames, Set<String> fieldNames) {
            return new GetVariablesRequest().setTaskId(taskSearchView.getId()).setFlowNodeInstanceId(taskSearchView.getFlowNodeInstanceId()).setState(taskSearchView.getState()).setProcessInstanceId(taskSearchView.getProcessInstanceId()).setVarNames(varNames).setFieldNames(fieldNames);
        }

        public String getTaskId() {
            return this.taskId;
        }

        public GetVariablesRequest setTaskId(String taskId) {
            this.taskId = taskId;
            return this;
        }

        public TaskState getState() {
            return this.state;
        }

        public GetVariablesRequest setState(TaskState state) {
            this.state = state;
            return this;
        }

        public String getFlowNodeInstanceId() {
            return this.flowNodeInstanceId;
        }

        public GetVariablesRequest setFlowNodeInstanceId(String flowNodeInstanceId) {
            this.flowNodeInstanceId = flowNodeInstanceId;
            return this;
        }

        public String getProcessInstanceId() {
            return this.processInstanceId;
        }

        public GetVariablesRequest setProcessInstanceId(String processInstanceId) {
            this.processInstanceId = processInstanceId;
            return this;
        }

        public List<String> getVarNames() {
            return this.varNames;
        }

        public GetVariablesRequest setVarNames(List<String> varNames) {
            this.varNames = varNames;
            return this;
        }

        public Set<String> getFieldNames() {
            return this.fieldNames;
        }

        public GetVariablesRequest setFieldNames(Set<String> fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GetVariablesRequest that = (GetVariablesRequest)o;
            return Objects.equals(this.taskId, that.taskId) && this.state == that.state && Objects.equals(this.flowNodeInstanceId, that.flowNodeInstanceId) && Objects.equals(this.processInstanceId, that.processInstanceId) && Objects.equals(this.varNames, that.varNames) && Objects.equals(this.fieldNames, that.fieldNames);
        }

        public int hashCode() {
            return Objects.hash(this.taskId, this.state, this.flowNodeInstanceId, this.processInstanceId, this.varNames, this.fieldNames);
        }
    }

    public static class VariableMap
    extends HashMap<String, VariableEntity> {
        public void putAll(VariableMap m) {
            for (Map.Entry entry : m.entrySet()) {
                this.putIfAbsent((String)entry.getKey(), (VariableEntity)entry.getValue());
            }
        }

        @Override
        @Deprecated
        public void putAll(Map<? extends String, ? extends VariableEntity> m) {
            super.putAll(m);
        }
    }

    public static class FlowNodeTree
    extends HashMap<String, String> {
        public String getParent(String currentFlowNodeInstanceId) {
            return (String)super.get(currentFlowNodeInstanceId);
        }

        public void setParent(String currentFlowNodeInstanceId, String parentFlowNodeInstanceId) {
            super.put(currentFlowNodeInstanceId, parentFlowNodeInstanceId);
        }

        public Set<String> getFlowNodeInstanceIds() {
            return super.keySet();
        }
    }
}

