/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema.migration.es;

import io.camunda.tasklist.es.RetryElasticsearchClient;
import io.camunda.tasklist.exceptions.MigrationException;
import io.camunda.tasklist.schema.migration.Step;
import io.camunda.tasklist.util.CollectionUtil;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReindexPlanElasticSearch {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReindexPlanElasticSearch.class);
    private static final String DEFAULT_SCRIPT = "ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()))";
    private List<Step> steps = List.of();
    private Script script;
    private String srcIndex;
    private String dstIndex;
    private int reindexBatchSize = 1000;
    private int slices;

    public Script getScript() {
        return this.script;
    }

    public ReindexPlanElasticSearch buildScript(Script script) {
        this.script = script;
        return this;
    }

    public String getSrcIndex() {
        return this.srcIndex;
    }

    public ReindexPlanElasticSearch setSrcIndex(String srcIndex) {
        this.srcIndex = srcIndex;
        return this;
    }

    public String getDstIndex() {
        return this.dstIndex;
    }

    public ReindexPlanElasticSearch setDstIndex(String dstIndex) {
        this.dstIndex = dstIndex;
        return this;
    }

    public ReindexPlanElasticSearch buildScript(String scriptContent, Map<String, Object> params) {
        this.script = new Script(ScriptType.INLINE, "painless", scriptContent, params);
        return this;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public ReindexPlanElasticSearch setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeOn(RetryElasticsearchClient retryElasticsearchClient) throws MigrationException {
        ReindexRequest reindexRequest = ((ReindexRequest)new ReindexRequest().setSourceIndices(new String[]{this.srcIndex + "_*"}).setDestIndex(this.dstIndex + "_").setSlices(this.slices)).setSourceBatchSize(this.reindexBatchSize);
        Optional<String> pipelineName = this.createPipelineFromSteps(retryElasticsearchClient);
        pipelineName.ifPresent(arg_0 -> ((ReindexRequest)reindexRequest).setDestPipeline(arg_0));
        if (this.script == null) {
            this.buildScript(DEFAULT_SCRIPT, Map.of("dstIndex", this.dstIndex));
        }
        reindexRequest.setScript(this.script);
        try {
            retryElasticsearchClient.reindex(reindexRequest);
        }
        finally {
            pipelineName.ifPresent(retryElasticsearchClient::removePipeline);
        }
    }

    private Optional<String> createPipelineFromSteps(RetryElasticsearchClient retryElasticsearchClient) throws MigrationException {
        if (this.steps.isEmpty()) {
            return Optional.empty();
        }
        String name = this.srcIndex + "-to-" + this.dstIndex + "-pipeline";
        boolean added = retryElasticsearchClient.addPipeline(name, this.getPipelineDefinition());
        if (added) {
            return Optional.of(name);
        }
        throw new MigrationException(String.format("Couldn't create '%s' pipeline.", name));
    }

    private String getPipelineDefinition() {
        List stepsAsJSON = CollectionUtil.map(this.steps, Step::getContent);
        return "{ \"processors\": [" + String.join((CharSequence)", ", stepsAsJSON) + "] }";
    }

    public String toString() {
        return "ReindexPlanElasticSearch [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }

    public ReindexPlanElasticSearch setBatchSize(int reindexBatchSize) {
        this.reindexBatchSize = reindexBatchSize;
        return this;
    }

    public ReindexPlanElasticSearch setSlices(int slices) {
        this.slices = slices;
        return this;
    }

    public static ReindexPlanElasticSearch create() {
        return new ReindexPlanElasticSearch();
    }
}

