/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IndexMapping {
    private String indexName;
    private String dynamic;
    private Set<IndexMappingProperty> properties;
    private Map<String, Object> metaProperties;

    public String getIndexName() {
        return this.indexName;
    }

    public IndexMapping setIndexName(String indexName) {
        this.indexName = indexName;
        return this;
    }

    public String getDynamic() {
        return this.dynamic;
    }

    public IndexMapping setDynamic(String dynamic) {
        this.dynamic = dynamic == null ? null : dynamic.toLowerCase();
        return this;
    }

    public Set<IndexMappingProperty> getProperties() {
        return this.properties;
    }

    public IndexMapping setProperties(Set<IndexMappingProperty> properties) {
        this.properties = properties;
        return this;
    }

    public Map<String, Object> toMap() {
        return this.properties.stream().collect(Collectors.toMap(IndexMappingProperty::getName, IndexMappingProperty::getTypeDefinition));
    }

    public Map<String, Object> getMetaProperties() {
        return this.metaProperties;
    }

    public IndexMapping setMetaProperties(Map<String, Object> metaProperties) {
        this.metaProperties = metaProperties;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.indexName, this.dynamic, this.properties, this.metaProperties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexMapping that = (IndexMapping)o;
        return Objects.equals(this.indexName, that.indexName) && Objects.equals(this.properties, that.properties) && Objects.equals(this.dynamic, that.dynamic) && Objects.equals(this.metaProperties, that.metaProperties);
    }

    public String toString() {
        return "IndexMapping{indexName='" + this.indexName + "', dynamic='" + this.dynamic + "', properties=" + String.valueOf(this.properties) + ", metaProperties=" + String.valueOf(this.metaProperties) + "}";
    }

    public static class IndexMappingProperty {
        private String name;
        private Object typeDefinition;

        public String getName() {
            return this.name;
        }

        public IndexMappingProperty setName(String name) {
            this.name = name;
            return this;
        }

        public Object getTypeDefinition() {
            return this.typeDefinition;
        }

        public IndexMappingProperty setTypeDefinition(Object typeDefinition) {
            this.typeDefinition = typeDefinition;
            return this;
        }

        public static String toJsonString(Set<IndexMappingProperty> properties, ObjectMapper objectMapper) {
            try {
                Map<String, Object> fields = properties.stream().collect(Collectors.toMap(p -> p.getName(), p -> p.getTypeDefinition()));
                return objectMapper.writeValueAsString(fields);
            }
            catch (JsonProcessingException e) {
                throw new TasklistRuntimeException((Throwable)e);
            }
        }

        public static IndexMappingProperty createIndexMappingProperty(Map.Entry<String, Object> propertiesMapEntry) {
            return new IndexMappingProperty().setName(propertiesMapEntry.getKey()).setTypeDefinition(propertiesMapEntry.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.name, this.typeDefinition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IndexMappingProperty that = (IndexMappingProperty)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.typeDefinition, that.typeDefinition);
        }

        public String toString() {
            return "IndexMappingProperty{name='" + this.name + "', typeDefinition=" + String.valueOf(this.typeDefinition) + "}";
        }
    }
}

