/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.es;

import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.es.RetryElasticsearchClient;
import io.camunda.tasklist.management.ILMPolicyUpdate;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.manager.ElasticsearchSchemaManager;
import java.io.IOException;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyRequest;
import org.elasticsearch.client.indexlifecycle.GetLifecyclePolicyResponse;
import org.elasticsearch.common.settings.Settings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticSearchCondition.class})
public class ILMPolicyUpdateElasticSearch
implements ILMPolicyUpdate {
    private static final String TASKLIST_DELETE_ARCHIVED_INDICES = "tasklist_delete_archived_indices";
    private static final String INDEX_LIFECYCLE_NAME = "index.lifecycle.name";
    private static final Logger LOGGER = LoggerFactory.getLogger(ILMPolicyUpdateElasticSearch.class);
    @Autowired
    private RetryElasticsearchClient retryElasticsearchClient;
    @Autowired
    private ElasticsearchSchemaManager schemaManager;
    @Autowired
    private TasklistProperties tasklistProperties;

    @Override
    public void applyIlmPolicyToAllIndices() throws IOException {
        String taskListIndexWildCard = this.tasklistProperties.getElasticsearch().getIndexPrefix() + "-*";
        String archiveTemplatePatterndNameRegex = "^" + this.tasklistProperties.getElasticsearch().getIndexPrefix() + "-.*-\\d+\\.\\d+\\.\\d+_\\d{4}-\\d{2}-\\d{2}$";
        LOGGER.info("Applying ILM policy to all existent indices");
        GetLifecyclePolicyResponse policy = this.retryElasticsearchClient.getLifeCyclePolicy(new GetLifecyclePolicyRequest(new String[]{TASKLIST_DELETE_ARCHIVED_INDICES}));
        if (policy == null) {
            LOGGER.info("ILM policy not found, creating it");
            this.schemaManager.createIndexLifeCycles();
        }
        Pattern indexNamePattern = Pattern.compile(archiveTemplatePatterndNameRegex);
        Set<String> response = this.retryElasticsearchClient.getIndexNames(taskListIndexWildCard);
        for (String indexName : response) {
            if (!indexNamePattern.matcher(indexName).matches()) continue;
            Settings settings = Settings.builder().put(INDEX_LIFECYCLE_NAME, TASKLIST_DELETE_ARCHIVED_INDICES).build();
            this.retryElasticsearchClient.setIndexSettingsFor(settings, indexName);
        }
    }

    @Override
    public void removeIlmPolicyFromAllIndices() {
        String taskListIndexWildCard = this.tasklistProperties.getElasticsearch().getIndexPrefix() + "-*";
        String archiveTemplatePatterndNameRegex = "^" + this.tasklistProperties.getElasticsearch().getIndexPrefix() + "-.*-\\d+\\.\\d+\\.\\d+_\\d{4}-\\d{2}-\\d{2}$";
        LOGGER.info("Removing ILM policy to all existent indices");
        Pattern indexNamePattern = Pattern.compile(archiveTemplatePatterndNameRegex);
        Set<String> response = this.retryElasticsearchClient.getIndexNames(taskListIndexWildCard);
        for (String indexName : response) {
            if (!indexNamePattern.matcher(indexName).matches()) continue;
            Settings settings = Settings.builder().putNull(INDEX_LIFECYCLE_NAME).build();
            this.retryElasticsearchClient.setIndexSettingsFor(settings, indexName);
        }
    }
}

