/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.data.os;

import io.camunda.tasklist.data.DataGenerator;
import io.camunda.tasklist.data.DevDataGeneratorAbstract;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.entities.UserEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"dev-data"})
@Conditional(value={OpenSearchCondition.class})
public class DevDataGeneratorOpenSearch
extends DevDataGeneratorAbstract
implements DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevDataGeneratorOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeOsClient")
    private OpenSearchClient zeebeOsClient;
    @Qualifier(value="tasklistOsClient")
    @Autowired
    private OpenSearchClient osClient;

    public void createUser(String username, String firstname, String lastname) {
        String password = username;
        String passwordEncoded = this.passwordEncoder.encode((CharSequence)password);
        UserEntity user = UserEntity.from((String)username, (String)passwordEncoded, List.of("USER")).setDisplayName(firstname + " " + lastname).setRoles(Arrays.asList("OWNER"));
        try {
            IndexRequest request = new IndexRequest.Builder().index(this.userIndex.getFullQualifiedName()).id(user.getId()).document((Object)user).build();
            this.osClient.index(request);
        }
        catch (Exception t) {
            LOGGER.error("Could not create demo user with user id {}", (Object)user.getUserId(), (Object)t);
        }
        LOGGER.info("Created demo user {} with password {}", (Object)username, (Object)password);
    }

    public boolean shouldCreateData() {
        try {
            boolean exists = this.zeebeOsClient.indices().exists(e -> e.index(List.of(this.tasklistProperties.getZeebeOpenSearch().getPrefix() + "*")).allowNoIndices(Boolean.valueOf(false)).ignoreUnavailable(Boolean.valueOf(true))).value();
            if (exists) {
                LOGGER.debug("Data already exists in Zeebe.");
                return false;
            }
        }
        catch (IOException io) {
            LOGGER.debug("Error occurred while checking existance of data in Zeebe: {}. Demo data won't be created.", (Object)io.getMessage());
            return false;
        }
        return true;
    }
}

