/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.data.es;

import io.camunda.tasklist.data.DataGenerator;
import io.camunda.tasklist.data.DevDataGeneratorAbstract;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.UserEntity;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"dev-data"})
@Conditional(value={ElasticSearchCondition.class})
public class DevDataGeneratorElasticSearch
extends DevDataGeneratorAbstract
implements DataGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DevDataGeneratorElasticSearch.class);
    @Autowired
    @Qualifier(value="tasklistZeebeEsClient")
    private RestHighLevelClient zeebeEsClient;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;

    public void createUser(String username, String firstname, String lastname) {
        String password = username;
        String passwordEncoded = this.passwordEncoder.encode((CharSequence)password);
        UserEntity user = UserEntity.from((String)username, (String)passwordEncoded, List.of("USER")).setDisplayName(firstname + " " + lastname).setRoles(Arrays.asList("OWNER"));
        try {
            IndexRequest request = new IndexRequest(this.userIndex.getFullQualifiedName()).id(user.getId()).source(this.userEntityToJSONString(user), XContentType.JSON);
            this.esClient.index(request, RequestOptions.DEFAULT);
        }
        catch (Exception t) {
            LOGGER.error("Could not create demo user with user id {}", (Object)user.getUserId(), (Object)t);
        }
        LOGGER.info("Created demo user {} with password {}", (Object)username, (Object)password);
    }

    public boolean shouldCreateData() {
        try {
            GetIndexRequest request = new GetIndexRequest(new String[]{this.tasklistProperties.getZeebeElasticsearch().getPrefix() + "*"});
            request.indicesOptions(IndicesOptions.fromOptions((boolean)true, (boolean)false, (boolean)true, (boolean)false));
            boolean exists = this.zeebeEsClient.indices().exists(request, RequestOptions.DEFAULT);
            if (exists) {
                LOGGER.debug("Data already exists in Zeebe.");
                return false;
            }
        }
        catch (IOException io) {
            LOGGER.debug("Error occurred while checking existance of data in Zeebe: {}. Demo data won't be created.", (Object)io.getMessage());
            return false;
        }
        return true;
    }
}

