/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.views;

import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TaskImplementation;
import io.camunda.tasklist.entities.TaskState;
import io.camunda.tasklist.util.CollectionUtil;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;

public class TaskSearchView {
    private String id;
    private String bpmnProcessId;
    private String processDefinitionId;
    private String flowNodeBpmnId;
    private String flowNodeInstanceId;
    private String processInstanceId;
    private OffsetDateTime creationTime;
    private OffsetDateTime completionTime;
    private TaskState state;
    private String assignee;
    private String[] candidateGroups;
    private String[] candidateUsers;
    private String formKey;
    private String formId;
    private Long formVersion;
    private Boolean isFormEmbedded;
    private String tenantId;
    private OffsetDateTime followUpDate;
    private OffsetDateTime dueDate;
    private boolean first = false;
    private String[] sortValues;
    private TaskImplementation implementation;
    private Integer priority;

    public String getId() {
        return this.id;
    }

    public TaskSearchView setId(String id) {
        this.id = id;
        return this;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public TaskSearchView setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public TaskSearchView setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
        return this;
    }

    public String getFlowNodeBpmnId() {
        return this.flowNodeBpmnId;
    }

    public TaskSearchView setFlowNodeBpmnId(String flowNodeBpmnId) {
        this.flowNodeBpmnId = flowNodeBpmnId;
        return this;
    }

    public String getFlowNodeInstanceId() {
        return this.flowNodeInstanceId;
    }

    public TaskSearchView setFlowNodeInstanceId(String flowNodeInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
        return this;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public TaskSearchView setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        return this;
    }

    public OffsetDateTime getCreationTime() {
        return this.creationTime;
    }

    public TaskSearchView setCreationTime(OffsetDateTime creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public OffsetDateTime getCompletionTime() {
        return this.completionTime;
    }

    public TaskSearchView setCompletionTime(OffsetDateTime completionTime) {
        this.completionTime = completionTime;
        return this;
    }

    public TaskState getState() {
        return this.state;
    }

    public TaskSearchView setState(TaskState state) {
        this.state = state;
        return this;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public TaskSearchView setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public String[] getCandidateGroups() {
        return this.candidateGroups;
    }

    public TaskSearchView setCandidateGroups(String[] candidateGroups) {
        this.candidateGroups = candidateGroups;
        return this;
    }

    public String[] getCandidateUsers() {
        return this.candidateUsers;
    }

    public TaskSearchView setCandidateUsers(String[] candidateUsers) {
        this.candidateUsers = candidateUsers;
        return this;
    }

    public String getFormKey() {
        return this.formKey;
    }

    public TaskSearchView setFormKey(String formKey) {
        this.formKey = formKey;
        return this;
    }

    public String getFormId() {
        return this.formId;
    }

    public TaskSearchView setFormId(String formId) {
        this.formId = formId;
        return this;
    }

    public Long getFormVersion() {
        return this.formVersion;
    }

    public TaskSearchView setFormVersion(Long formVersion) {
        this.formVersion = formVersion;
        return this;
    }

    public Boolean getIsFormEmbedded() {
        return this.isFormEmbedded;
    }

    public TaskSearchView setIsFormEmbedded(Boolean isFormEmbedded) {
        this.isFormEmbedded = isFormEmbedded;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public TaskSearchView setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public OffsetDateTime getFollowUpDate() {
        return this.followUpDate;
    }

    public TaskSearchView setFollowUpDate(OffsetDateTime followUpDate) {
        this.followUpDate = followUpDate;
        return this;
    }

    public OffsetDateTime getDueDate() {
        return this.dueDate;
    }

    public TaskSearchView setDueDate(OffsetDateTime dueDate) {
        this.dueDate = dueDate;
        return this;
    }

    public boolean isFirst() {
        return this.first;
    }

    public TaskSearchView setFirst(boolean first) {
        this.first = first;
        return this;
    }

    public String[] getSortValues() {
        return this.sortValues;
    }

    public TaskSearchView setSortValues(String[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public TaskImplementation getImplementation() {
        return this.implementation;
    }

    public TaskSearchView setImplementation(TaskImplementation implementation) {
        this.implementation = implementation;
        return this;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public TaskSearchView setPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{super.hashCode(), this.id, this.bpmnProcessId, this.processDefinitionId, this.flowNodeBpmnId, this.flowNodeInstanceId, this.processInstanceId, this.creationTime, this.completionTime, this.state, this.assignee, this.formKey, this.formId, this.formVersion, this.isFormEmbedded, this.tenantId, this.followUpDate, this.dueDate, this.first, this.implementation, this.priority});
        result = 31 * result + Arrays.hashCode(this.candidateGroups);
        result = 31 * result + Arrays.hashCode(this.candidateUsers);
        result = 31 * result + Arrays.hashCode(this.sortValues);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskSearchView that = (TaskSearchView)o;
        return this.first == that.first && this.implementation == that.implementation && Objects.equals(this.id, that.id) && Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.equals(this.processDefinitionId, that.processDefinitionId) && Objects.equals(this.flowNodeBpmnId, that.flowNodeBpmnId) && Objects.equals(this.flowNodeInstanceId, that.flowNodeInstanceId) && Objects.equals(this.processInstanceId, that.processInstanceId) && Objects.equals(this.creationTime, that.creationTime) && Objects.equals(this.completionTime, that.completionTime) && this.state == that.state && Objects.equals(this.assignee, that.assignee) && Arrays.equals(this.candidateGroups, that.candidateGroups) && Arrays.equals(this.candidateUsers, that.candidateUsers) && Objects.equals(this.formKey, that.formKey) && Objects.equals(this.formId, that.formId) && Objects.equals(this.formVersion, that.formVersion) && Objects.equals(this.isFormEmbedded, that.isFormEmbedded) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.followUpDate, that.followUpDate) && Objects.equals(this.dueDate, that.dueDate) && Objects.equals(this.priority, that.priority) && Arrays.equals(this.sortValues, that.sortValues);
    }

    public String toString() {
        return new StringJoiner(", ", TaskSearchView.class.getSimpleName() + "[", "]").add("bpmnProcessId='" + this.id + "'").add("bpmnProcessId='" + this.bpmnProcessId + "'").add("processDefinitionId='" + this.processDefinitionId + "'").add("flowNodeBpmnId='" + this.flowNodeBpmnId + "'").add("flowNodeInstanceId='" + this.flowNodeInstanceId + "'").add("processInstanceId='" + this.processInstanceId + "'").add("creationTime=" + String.valueOf(this.creationTime)).add("completionTime=" + String.valueOf(this.completionTime)).add("state=" + String.valueOf((Object)this.state)).add("assignee='" + this.assignee + "'").add("candidateGroups=" + Arrays.toString(this.candidateGroups)).add("candidateUsers=" + Arrays.toString(this.candidateUsers)).add("formKey='" + this.formKey + "'").add("formId='" + this.formId + "'").add("formVersion='" + this.formVersion + "'").add("isFormEmbedded=" + this.isFormEmbedded).add("tenantId='" + this.tenantId + "'").add("followUpDate=" + String.valueOf(this.followUpDate)).add("dueDate=" + String.valueOf(this.dueDate)).add("first=" + this.first).add("sortValues=" + Arrays.toString(this.sortValues)).add("implementation=" + String.valueOf((Object)this.implementation)).add("priority=" + this.priority).toString();
    }

    public static TaskSearchView createFrom(TaskEntity taskEntity, Object[] sortValues) {
        TaskSearchView taskSearchView = new TaskSearchView().setId(taskEntity.getId()).setCreationTime(taskEntity.getCreationTime()).setCompletionTime(taskEntity.getCompletionTime()).setProcessInstanceId(taskEntity.getProcessInstanceId()).setState(taskEntity.getState()).setAssignee(taskEntity.getAssignee()).setBpmnProcessId(taskEntity.getBpmnProcessId()).setProcessDefinitionId(taskEntity.getProcessDefinitionId()).setFlowNodeBpmnId(taskEntity.getFlowNodeBpmnId()).setFlowNodeInstanceId(taskEntity.getFlowNodeInstanceId()).setFormKey(taskEntity.getFormKey()).setFormId(taskEntity.getFormId()).setFormVersion(taskEntity.getFormVersion()).setIsFormEmbedded(taskEntity.getIsFormEmbedded()).setTenantId(taskEntity.getTenantId()).setFollowUpDate(taskEntity.getFollowUpDate()).setDueDate(taskEntity.getDueDate()).setCandidateGroups(taskEntity.getCandidateGroups()).setCandidateUsers(taskEntity.getCandidateUsers()).setImplementation(taskEntity.getImplementation()).setPriority(taskEntity.getPriority());
        if (sortValues != null) {
            taskSearchView.setSortValues(CollectionUtil.toArrayOfStrings(sortValues));
        }
        return taskSearchView;
    }
}

