/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class PayloadUtil {
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    public Map<String, Object> parsePayload(String payload) throws IOException {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        this.traverseTheTree(this.objectMapper.readTree(payload), map, "");
        return map;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String readJSONStringFromClasspath(String filename) {
        try (InputStream inputStream = PayloadUtil.class.getResourceAsStream(filename);){
            if (inputStream == null) throw new TasklistRuntimeException("Failed to find " + filename + " in classpath ");
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new TasklistRuntimeException("Failed to load file " + filename + " from classpath ", e);
        }
    }

    private void traverseTheTree(JsonNode jsonNode, Map<String, Object> map, String path) {
        block14: {
            block15: {
                block13: {
                    if (!jsonNode.isValueNode()) break block13;
                    Object value = null;
                    block0 : switch (jsonNode.getNodeType()) {
                        case BOOLEAN: {
                            value = jsonNode.booleanValue();
                            break;
                        }
                        case NUMBER: {
                            switch (jsonNode.numberType()) {
                                case INT: 
                                case LONG: 
                                case BIG_INTEGER: {
                                    value = jsonNode.longValue();
                                    break block0;
                                }
                                case FLOAT: 
                                case DOUBLE: 
                                case BIG_DECIMAL: {
                                    value = jsonNode.doubleValue();
                                    break block0;
                                }
                            }
                            break;
                        }
                        case STRING: {
                            value = jsonNode.textValue();
                            break;
                        }
                        case NULL: {
                            break;
                        }
                        case BINARY: {
                            break;
                        }
                    }
                    map.put(path, value);
                    break block14;
                }
                if (!jsonNode.isContainerNode()) break block14;
                if (!jsonNode.isObject()) break block15;
                Iterator fieldIterator = jsonNode.fieldNames();
                while (fieldIterator.hasNext()) {
                    String fieldName = (String)fieldIterator.next();
                    this.traverseTheTree(jsonNode.get(fieldName), map, (String)(path.isEmpty() ? "" : path + ".") + fieldName);
                }
                break block14;
            }
            if (!jsonNode.isArray()) break block14;
            int i = 0;
            for (JsonNode child : jsonNode) {
                this.traverseTheTree(child, map, path + "[" + i + "]");
                ++i;
            }
        }
    }
}

