/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.property;

import io.camunda.tasklist.property.ArchiverProperties;
import io.camunda.tasklist.property.Auth0Properties;
import io.camunda.tasklist.property.BackupProperties;
import io.camunda.tasklist.property.ClientProperties;
import io.camunda.tasklist.property.CloudProperties;
import io.camunda.tasklist.property.ClusterNodeProperties;
import io.camunda.tasklist.property.FeatureFlagProperties;
import io.camunda.tasklist.property.IdentityProperties;
import io.camunda.tasklist.property.ImportProperties;
import io.camunda.tasklist.property.MultiTenancyProperties;
import io.camunda.tasklist.property.SecurityProperties;
import io.camunda.tasklist.property.TasklistDocumentationProperties;
import io.camunda.tasklist.property.TasklistElasticsearchProperties;
import io.camunda.tasklist.property.TasklistOpenSearchProperties;
import io.camunda.tasklist.property.ZeebeElasticsearchProperties;
import io.camunda.tasklist.property.ZeebeOpenSearchProperties;
import io.camunda.tasklist.property.ZeebeProperties;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@Configuration
@ConfigurationProperties(value="camunda.tasklist")
@PropertySource(value={"classpath:tasklist-version.properties"})
public class TasklistProperties {
    public static final String PREFIX = "camunda.tasklist";
    public static final String ALPHA_RELEASES_SUFIX = "alpha";
    public static final long BATCH_OPERATION_MAX_SIZE_DEFAULT = 1000000L;
    public static final String ELASTIC_SEARCH = "elasticsearch";
    public static final String OPEN_SEARCH = "opensearch";
    private static final String UNKNOWN_VERSION = "unknown-version";
    private boolean importerEnabled = true;
    private boolean archiverEnabled = true;
    private boolean webappEnabled = true;
    private boolean persistentSessionsEnabled = false;
    private boolean csrfPreventionEnabled = true;
    private boolean fixUsernames = true;
    private String userId = "demo";
    private String displayName = "demo";
    private String password = "demo";
    private String operatorUserId = "act";
    private String operatorPassword = "act";
    private String operatorDisplayName = "act";
    private String readerUserId = "view";
    private String readerPassword = "view";
    private String readerDisplayName = "view";
    private String database = "elasticsearch";
    private List<String> roles = List.of("OWNER");
    private Long batchOperationMaxSize = 1000000L;
    private boolean enterprise = false;
    @Value(value="${camunda.tasklist.internal.version.current}")
    private String version = "unknown-version";
    @NestedConfigurationProperty
    private SecurityProperties securityProperties = new SecurityProperties();
    @NestedConfigurationProperty
    private TasklistElasticsearchProperties elasticsearch = new TasklistElasticsearchProperties();
    @NestedConfigurationProperty
    private TasklistOpenSearchProperties openSearch = new TasklistOpenSearchProperties();
    @NestedConfigurationProperty
    private ZeebeElasticsearchProperties zeebeElasticsearch = new ZeebeElasticsearchProperties();
    @NestedConfigurationProperty
    private ZeebeOpenSearchProperties zeebeOpenSearch = new ZeebeOpenSearchProperties();
    @NestedConfigurationProperty
    private ZeebeProperties zeebe = new ZeebeProperties();
    @NestedConfigurationProperty
    private ImportProperties importer = new ImportProperties();
    @NestedConfigurationProperty
    private ArchiverProperties archiver = new ArchiverProperties();
    @NestedConfigurationProperty
    private ClientProperties client = new ClientProperties();
    @NestedConfigurationProperty
    private CloudProperties cloud = new CloudProperties();
    @NestedConfigurationProperty
    private FeatureFlagProperties featureFlag = new FeatureFlagProperties();
    @NestedConfigurationProperty
    private ClusterNodeProperties clusterNode = new ClusterNodeProperties();
    @NestedConfigurationProperty
    private Auth0Properties auth0 = new Auth0Properties();
    @NestedConfigurationProperty
    private IdentityProperties identity = new IdentityProperties();
    @NestedConfigurationProperty
    private BackupProperties backup = new BackupProperties();
    @NestedConfigurationProperty
    private MultiTenancyProperties multiTenancy = new MultiTenancyProperties();
    @NestedConfigurationProperty
    private TasklistDocumentationProperties documentation = new TasklistDocumentationProperties();

    public boolean isImporterEnabled() {
        return this.importerEnabled;
    }

    public void setImporterEnabled(boolean importerEnabled) {
        this.importerEnabled = importerEnabled;
    }

    public boolean isArchiverEnabled() {
        return this.archiverEnabled;
    }

    public void setArchiverEnabled(boolean archiverEnabled) {
        this.archiverEnabled = archiverEnabled;
    }

    public boolean isWebappEnabled() {
        return this.webappEnabled;
    }

    public void setWebappEnabled(boolean webappEnabled) {
        this.webappEnabled = webappEnabled;
    }

    public Long getBatchOperationMaxSize() {
        return this.batchOperationMaxSize;
    }

    public void setBatchOperationMaxSize(Long batchOperationMaxSize) {
        this.batchOperationMaxSize = batchOperationMaxSize;
    }

    public boolean isAlphaVersion() {
        return this.getVersion().toLowerCase().contains(ALPHA_RELEASES_SUFIX);
    }

    public boolean isSelfManaged() {
        return this.getCloud().getClusterId() == null;
    }

    public boolean isCsrfPreventionEnabled() {
        return this.csrfPreventionEnabled;
    }

    public void setCsrfPreventionEnabled(boolean csrfPreventionEnabled) {
        this.csrfPreventionEnabled = csrfPreventionEnabled;
    }

    public TasklistElasticsearchProperties getElasticsearch() {
        return this.elasticsearch;
    }

    public void setElasticsearch(TasklistElasticsearchProperties elasticsearch) {
        this.elasticsearch = elasticsearch;
    }

    public ZeebeElasticsearchProperties getZeebeElasticsearch() {
        return this.zeebeElasticsearch;
    }

    public void setZeebeElasticsearch(ZeebeElasticsearchProperties zeebeElasticsearch) {
        this.zeebeElasticsearch = zeebeElasticsearch;
    }

    public ZeebeProperties getZeebe() {
        return this.zeebe;
    }

    public void setZeebe(ZeebeProperties zeebe) {
        this.zeebe = zeebe;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public ImportProperties getImporter() {
        return this.importer;
    }

    public void setImporter(ImportProperties importer) {
        this.importer = importer;
    }

    public ArchiverProperties getArchiver() {
        return this.archiver;
    }

    public void setArchiver(ArchiverProperties archiver) {
        this.archiver = archiver;
    }

    public ClusterNodeProperties getClusterNode() {
        return this.clusterNode;
    }

    public void setClusterNode(ClusterNodeProperties clusterNode) {
        this.clusterNode = clusterNode;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public void setEnterprise(boolean enterprise) {
        this.enterprise = enterprise;
    }

    public ClientProperties getClient() {
        return this.client;
    }

    public void setClient(ClientProperties client) {
        this.client = client;
    }

    public boolean isPersistentSessionsEnabled() {
        return this.persistentSessionsEnabled;
    }

    public TasklistProperties setPersistentSessionsEnabled(boolean persistentSessionsEnabled) {
        this.persistentSessionsEnabled = persistentSessionsEnabled;
        return this;
    }

    public Auth0Properties getAuth0() {
        return this.auth0;
    }

    public TasklistProperties setAuth0(Auth0Properties auth0) {
        this.auth0 = auth0;
        return this;
    }

    public IdentityProperties getIdentity() {
        return this.identity;
    }

    public void setIdentity(IdentityProperties identity) {
        this.identity = identity;
    }

    public List<String> getRoles() {
        return this.roles;
    }

    public void setRoles(List<String> roles) {
        this.roles = roles;
    }

    public CloudProperties getCloud() {
        return this.cloud;
    }

    public void setCloud(CloudProperties cloud) {
        this.cloud = cloud;
    }

    public BackupProperties getBackup() {
        return this.backup;
    }

    public TasklistProperties setBackup(BackupProperties backup) {
        this.backup = backup;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public TasklistProperties setVersion(String version) {
        this.version = version;
        return this;
    }

    public boolean isFixUsernames() {
        return this.fixUsernames;
    }

    public void setFixUsernames(boolean fixUsernames) {
        this.fixUsernames = fixUsernames;
    }

    public SecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public TasklistProperties setSecurityProperties(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
        return this;
    }

    public FeatureFlagProperties getFeatureFlag() {
        return this.featureFlag;
    }

    public TasklistProperties setFeatureFlag(FeatureFlagProperties featureFlag) {
        this.featureFlag = featureFlag;
        return this;
    }

    public String getOperatorUserId() {
        return this.operatorUserId;
    }

    public TasklistProperties setOperatorUserId(String operatorUserId) {
        this.operatorUserId = operatorUserId;
        return this;
    }

    public String getOperatorPassword() {
        return this.operatorPassword;
    }

    public TasklistProperties setOperatorPassword(String operatorPassword) {
        this.operatorPassword = operatorPassword;
        return this;
    }

    public String getOperatorDisplayName() {
        return this.operatorDisplayName;
    }

    public TasklistProperties setOperatorDisplayName(String operatorDisplayName) {
        this.operatorDisplayName = operatorDisplayName;
        return this;
    }

    public String getReaderUserId() {
        return this.readerUserId;
    }

    public TasklistProperties setReaderUserId(String readerUserId) {
        this.readerUserId = readerUserId;
        return this;
    }

    public String getReaderPassword() {
        return this.readerPassword;
    }

    public TasklistProperties setReaderPassword(String readerPassword) {
        this.readerPassword = readerPassword;
        return this;
    }

    public String getReaderDisplayName() {
        return this.readerDisplayName;
    }

    public TasklistProperties setReaderDisplayName(String readerDisplayName) {
        this.readerDisplayName = readerDisplayName;
        return this;
    }

    public TasklistOpenSearchProperties getOpenSearch() {
        return this.openSearch;
    }

    public TasklistProperties setOpenSearch(TasklistOpenSearchProperties openSearch) {
        this.openSearch = openSearch;
        return this;
    }

    public String getDatabase() {
        return this.database;
    }

    public TasklistProperties setDatabase(String database) {
        this.database = database;
        return this;
    }

    public ZeebeOpenSearchProperties getZeebeOpenSearch() {
        return this.zeebeOpenSearch;
    }

    public TasklistProperties setZeebeOpenSearch(ZeebeOpenSearchProperties zeebeOpenSearch) {
        this.zeebeOpenSearch = zeebeOpenSearch;
        return this;
    }

    public MultiTenancyProperties getMultiTenancy() {
        return this.multiTenancy;
    }

    public TasklistProperties setMultiTenancy(MultiTenancyProperties multiTenancy) {
        this.multiTenancy = multiTenancy;
        return this;
    }

    public TasklistDocumentationProperties getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(TasklistDocumentationProperties documentation) {
        this.documentation = documentation;
    }

    public String getIndexPrefix() {
        if (this.database.equals(ELASTIC_SEARCH)) {
            return this.elasticsearch.getIndexPrefix();
        }
        if (this.database.equals(OPEN_SEARCH)) {
            return this.openSearch.getIndexPrefix();
        }
        return null;
    }
}

