/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.es;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.cluster.HealthResponse;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import io.camunda.search.connect.plugin.PluginRepository;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.ElasticsearchProperties;
import io.camunda.tasklist.property.SslProperties;
import io.camunda.tasklist.property.TasklistElasticsearchProperties;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.util.RetryOperation;
import jakarta.annotation.PreDestroy;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.RestHighLevelClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@Configuration
@Conditional(value={ElasticSearchCondition.class})
public class ElasticsearchConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchConnector.class);
    private PluginRepository esClientRepository = new PluginRepository();
    private PluginRepository zeebeEsClientRepository = new PluginRepository();
    @Autowired
    private TasklistProperties tasklistProperties;
    private ElasticsearchClient elasticsearchClient;

    public void setEsClientRepository(PluginRepository esClientRepository) {
        this.esClientRepository = esClientRepository;
    }

    public void setZeebeEsClientRepository(PluginRepository zeebeEsClientRepository) {
        this.zeebeEsClientRepository = zeebeEsClientRepository;
    }

    public void setTasklistProperties(TasklistProperties tasklistProperties) {
        this.tasklistProperties = tasklistProperties;
    }

    @Bean
    public ElasticsearchClient tasklistElasticsearchClient() {
        LOGGER.debug("Creating ElasticsearchClient ...");
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        this.esClientRepository.load(this.tasklistProperties.getElasticsearch().getInterceptorPlugins());
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getHttpHost(elsConfig)});
        if (elsConfig.getConnectTimeout() != null || elsConfig.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, elsConfig));
        }
        RestClient restClient = restClientBuilder.setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, elsConfig, new HttpRequestInterceptor[]{this.esClientRepository.asRequestInterceptor()})).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper());
        this.elasticsearchClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        if (!this.checkHealth(this.elasticsearchClient)) {
            LOGGER.warn("Elasticsearch cluster is not accessible");
        } else {
            LOGGER.debug("Elasticsearch connection was successfully created.");
        }
        return this.elasticsearchClient;
    }

    @PreDestroy
    public void tearDown() {
        if (this.elasticsearchClient != null) {
            try {
                ((ElasticsearchTransport)this.elasticsearchClient._transport()).close();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Bean(destroyMethod="close")
    public RestHighLevelClient tasklistEsClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.esClientRepository.load(this.tasklistProperties.getElasticsearch().getInterceptorPlugins());
        return this.createEsClient(this.tasklistProperties.getElasticsearch(), this.esClientRepository);
    }

    @Bean(destroyMethod="close")
    public RestHighLevelClient tasklistZeebeEsClient() {
        System.setProperty("es.set.netty.runtime.available.processors", "false");
        this.zeebeEsClientRepository.load(this.tasklistProperties.getZeebeElasticsearch().getInterceptorPlugins());
        return this.createEsClient(this.tasklistProperties.getZeebeElasticsearch(), this.zeebeEsClientRepository);
    }

    protected RestHighLevelClient createEsClient(ElasticsearchProperties elsConfig, PluginRepository pluginRepository) {
        RestHighLevelClient esClient;
        LOGGER.debug("Creating Elasticsearch connection...");
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])new HttpHost[]{this.getHttpHost(elsConfig)}).setHttpClientConfigCallback(httpClientBuilder -> this.configureHttpClient(httpClientBuilder, elsConfig, new HttpRequestInterceptor[]{pluginRepository.asRequestInterceptor()}));
        if (elsConfig.getConnectTimeout() != null || elsConfig.getSocketTimeout() != null) {
            restClientBuilder.setRequestConfigCallback(configCallback -> this.setTimeouts(configCallback, elsConfig));
        }
        if (!this.checkHealth(esClient = new RestHighLevelClientBuilder(restClientBuilder.build()).setApiCompatibilityMode(Boolean.valueOf(true)).build())) {
            LOGGER.warn("Elasticsearch cluster is not accessible");
        } else {
            LOGGER.debug("Elasticsearch connection was successfully created.");
        }
        return esClient;
    }

    private HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder httpAsyncClientBuilder, ElasticsearchProperties elsConfig, HttpRequestInterceptor ... interceptors) {
        this.setupAuthentication(httpAsyncClientBuilder, elsConfig);
        LOGGER.trace("Attempt to load interceptor plugins");
        for (HttpRequestInterceptor interceptor : interceptors) {
            httpAsyncClientBuilder.addInterceptorLast(interceptor);
        }
        if (elsConfig.getSsl() != null) {
            this.setupSSLContext(httpAsyncClientBuilder, elsConfig.getSsl());
        }
        return httpAsyncClientBuilder;
    }

    private void setupSSLContext(HttpAsyncClientBuilder httpAsyncClientBuilder, SslProperties sslConfig) {
        try {
            httpAsyncClientBuilder.setSSLContext(this.getSSLContext(sslConfig));
            if (!sslConfig.isVerifyHostname()) {
                httpAsyncClientBuilder.setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in setting up SSLContext", (Throwable)e);
        }
    }

    private SSLContext getSSLContext(SslProperties sslConfig) throws KeyStoreException, NoSuchAlgorithmException, KeyManagementException {
        TrustSelfSignedStrategy trustStrategy;
        KeyStore truststore = this.loadCustomTrustStore(sslConfig);
        TrustSelfSignedStrategy trustSelfSignedStrategy = trustStrategy = sslConfig.isSelfSigned() ? new TrustSelfSignedStrategy() : null;
        if (truststore.size() > 0) {
            return SSLContexts.custom().loadTrustMaterial(truststore, (TrustStrategy)trustStrategy).build();
        }
        return SSLContext.getDefault();
    }

    private KeyStore loadCustomTrustStore(SslProperties sslConfig) {
        try {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null);
            String serverCertificate = sslConfig.getCertificatePath();
            if (serverCertificate != null) {
                this.setCertificateInTrustStore(trustStore, serverCertificate);
            }
            return trustStore;
        }
        catch (Exception e) {
            String message = "Could not create certificate trustStore for the secured Elasticsearch Connection!";
            throw new TasklistRuntimeException("Could not create certificate trustStore for the secured Elasticsearch Connection!", e);
        }
    }

    private void setCertificateInTrustStore(KeyStore trustStore, String serverCertificate) {
        try {
            Certificate cert = this.loadCertificateFromPath(serverCertificate);
            trustStore.setCertificateEntry("elasticsearch-host", cert);
        }
        catch (Exception e) {
            String message = "Could not load configured server certificate for the secured Elasticsearch Connection!";
            throw new TasklistRuntimeException("Could not load configured server certificate for the secured Elasticsearch Connection!", e);
        }
    }

    private Certificate loadCertificateFromPath(String certificatePath) throws IOException, CertificateException {
        Certificate cert;
        block6: {
            try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(certificatePath));){
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                if (bis.available() > 0) {
                    cert = cf.generateCertificate(bis);
                    LOGGER.debug("Found certificate: {}", (Object)cert);
                    break block6;
                }
                throw new TasklistRuntimeException("Could not load certificate from file, file is empty. File: " + certificatePath);
            }
        }
        return cert;
    }

    public boolean checkHealth(ElasticsearchClient elasticsearchClient) {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        try {
            return RetryOperation.newBuilder().noOfRetry(50).retryOn(IOException.class, ElasticsearchException.class).delayInterval(3, TimeUnit.SECONDS).message(String.format("Connect to Elasticsearch cluster [%s] at %s", elsConfig.getClusterName(), elsConfig.getUrl())).retryConsumer(() -> {
                HealthResponse healthResponse = elasticsearchClient.cluster().health();
                LOGGER.info("Elasticsearch cluster health: {}", (Object)healthResponse.status());
                return healthResponse.clusterName().equals(elsConfig.getClusterName());
            }).build().retry();
        }
        catch (Exception e) {
            throw new TasklistRuntimeException("Couldn't connect to Elasticsearch. Abort.", e);
        }
    }

    public boolean checkHealth(RestHighLevelClient esClient) {
        TasklistElasticsearchProperties elsConfig = this.tasklistProperties.getElasticsearch();
        RetryPolicy<Boolean> retryPolicy = this.getConnectionRetryPolicy(elsConfig);
        return (Boolean)Failsafe.with(retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> {
            ClusterHealthResponse clusterHealthResponse = esClient.cluster().health(new ClusterHealthRequest(), RequestOptions.DEFAULT);
            return clusterHealthResponse.getClusterName().equals(elsConfig.getClusterName());
        });
    }

    private RetryPolicy<Boolean> getConnectionRetryPolicy(ElasticsearchProperties elsConfig) {
        String logMessage = String.format("connect to Elasticsearch at %s", elsConfig.getUrl());
        return ((RetryPolicy)new RetryPolicy().handle(new Class[]{IOException.class, org.elasticsearch.ElasticsearchException.class})).withDelay(Duration.ofSeconds(3L)).withMaxAttempts(50).onRetry(e -> LOGGER.info("Retrying #{} {} due to {}", new Object[]{e.getAttemptCount(), logMessage, e.getLastFailure()})).onAbort(e -> LOGGER.error("Abort {} by {}", (Object)logMessage, (Object)e.getFailure())).onRetriesExceeded(e -> LOGGER.error("Retries {} exceeded for {}", (Object)e.getAttemptCount(), (Object)logMessage));
    }

    private RequestConfig.Builder setTimeouts(RequestConfig.Builder builder, ElasticsearchProperties elsConfig) {
        if (elsConfig.getSocketTimeout() != null) {
            builder.setSocketTimeout(elsConfig.getSocketTimeout().intValue());
        }
        if (elsConfig.getConnectTimeout() != null) {
            builder.setConnectTimeout(elsConfig.getConnectTimeout().intValue());
        }
        return builder;
    }

    private HttpHost getHttpHost(ElasticsearchProperties elsConfig) {
        try {
            URI uri = new URI(elsConfig.getUrl());
            return new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        }
        catch (URISyntaxException e) {
            throw new TasklistRuntimeException("Error in url: " + elsConfig.getUrl(), e);
        }
    }

    private HttpAsyncClientBuilder setupAuthentication(HttpAsyncClientBuilder builder, ElasticsearchProperties elsConfig) {
        if (!StringUtils.hasText((String)elsConfig.getUsername()) || !StringUtils.hasText((String)elsConfig.getPassword())) {
            LOGGER.warn("Username and/or password for are empty. Basic authentication for elasticsearch is not used.");
            return builder;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(elsConfig.getUsername(), elsConfig.getPassword()));
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        return builder;
    }

    public static class CustomInstantDeserializer
    extends JsonDeserializer<Instant> {
        public Instant deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            return Instant.ofEpochMilli(Long.parseLong(parser.getText()));
        }
    }

    public static class CustomOffsetDateTimeDeserializer
    extends JsonDeserializer<OffsetDateTime> {
        private final DateTimeFormatter formatter;

        public CustomOffsetDateTimeDeserializer(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public OffsetDateTime deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            OffsetDateTime parsedDate;
            try {
                parsedDate = OffsetDateTime.parse(parser.getText(), this.formatter);
            }
            catch (DateTimeParseException exception) {
                throw new TasklistRuntimeException("Exception occurred when deserializing date.", exception);
            }
            return parsedDate;
        }
    }

    public static class CustomOffsetDateTimeSerializer
    extends JsonSerializer<OffsetDateTime> {
        private final DateTimeFormatter formatter;

        public CustomOffsetDateTimeSerializer(DateTimeFormatter formatter) {
            this.formatter = formatter;
        }

        public void serialize(OffsetDateTime value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            if (value == null) {
                gen.writeNull();
            } else {
                gen.writeString(value.format(this.formatter));
            }
        }
    }
}

