/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.entities;

import io.camunda.tasklist.entities.TaskEntity;
import io.camunda.tasklist.entities.TasklistZeebeEntity;
import java.util.Objects;

public class DraftTaskVariableEntity
extends TasklistZeebeEntity<DraftTaskVariableEntity> {
    private String taskId;
    private String name;
    private String value;
    private String fullValue;
    private boolean isPreview;

    public static String getIdBy(String idPrefix, String name) {
        return String.format("%s-%s", idPrefix, name);
    }

    public String getTaskId() {
        return this.taskId;
    }

    public DraftTaskVariableEntity setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public DraftTaskVariableEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public DraftTaskVariableEntity setValue(String value) {
        this.value = value;
        return this;
    }

    public String getFullValue() {
        return this.fullValue;
    }

    public DraftTaskVariableEntity setFullValue(String fullValue) {
        this.fullValue = fullValue;
        return this;
    }

    public boolean getIsPreview() {
        return this.isPreview;
    }

    public DraftTaskVariableEntity setIsPreview(boolean preview) {
        this.isPreview = preview;
        return this;
    }

    public static DraftTaskVariableEntity createFrom(TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        return DraftTaskVariableEntity.completeVariableSetup((DraftTaskVariableEntity)new DraftTaskVariableEntity().setId(DraftTaskVariableEntity.getIdBy(taskEntity.getId(), name)), taskEntity, name, value, variableSizeThreshold);
    }

    public static DraftTaskVariableEntity createFrom(String draftVariableId, TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        return DraftTaskVariableEntity.completeVariableSetup((DraftTaskVariableEntity)new DraftTaskVariableEntity().setId(draftVariableId), taskEntity, name, value, variableSizeThreshold);
    }

    private static DraftTaskVariableEntity completeVariableSetup(DraftTaskVariableEntity entity, TaskEntity taskEntity, String name, String value, int variableSizeThreshold) {
        entity.setTaskId(taskEntity.getId()).setName(name).setTenantId(taskEntity.getTenantId());
        if (value.length() > variableSizeThreshold) {
            entity.setValue(value.substring(0, variableSizeThreshold));
            entity.setIsPreview(true);
        } else {
            entity.setValue(value);
        }
        entity.setFullValue(value);
        return entity;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DraftTaskVariableEntity that = (DraftTaskVariableEntity)o;
        return this.isPreview == that.isPreview && Objects.equals(this.taskId, that.taskId) && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.fullValue, that.fullValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.taskId, this.name, this.value, this.fullValue, this.isPreview);
    }
}

