/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import io.camunda.tasklist.es.ElasticsearchConnector;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;

public final class CommonUtils {
    public static final ObjectMapper OBJECT_MAPPER = CommonUtils.getObjectMapper();

    public static ObjectMapper getObjectMapper() {
        JavaTimeModule javaTimeModule = new JavaTimeModule();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        javaTimeModule.addSerializer(OffsetDateTime.class, (JsonSerializer)new ElasticsearchConnector.CustomOffsetDateTimeSerializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(OffsetDateTime.class, (JsonDeserializer)new ElasticsearchConnector.CustomOffsetDateTimeDeserializer(dateTimeFormatter));
        javaTimeModule.addDeserializer(Instant.class, (JsonDeserializer)new ElasticsearchConnector.CustomInstantDeserializer());
        return Jackson2ObjectMapperBuilder.json().modules(new Module[]{javaTimeModule, new Jdk8Module()}).featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE, DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES}).featuresToEnable(new Object[]{JsonParser.Feature.ALLOW_COMMENTS, SerializationFeature.INDENT_OUTPUT}).build();
    }

    public static JsonObject getJsonObjectFromEntity(Object o) {
        return Json.createObjectBuilder((Map)((Map)OBJECT_MAPPER.convertValue(o, HashMap.class))).build();
    }

    public static JsonObjectBuilder getJsonObjectBuilderForEntity(Object o) {
        return Json.createObjectBuilder((Map)((Map)OBJECT_MAPPER.convertValue(o, HashMap.class)));
    }
}

