/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.os;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.archiver.AbstractArchiverJob;
import io.camunda.tasklist.archiver.ProcessInstanceArchiverJob;
import io.camunda.tasklist.archiver.os.AbstractArchiverJobOpenSearch;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.indices.FlowNodeInstanceIndex;
import io.camunda.tasklist.schema.indices.ProcessInstanceIndex;
import io.camunda.tasklist.schema.indices.VariableIndex;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.opensearch.client.opensearch.core.search.HitsMetadata;
import org.opensearch.client.util.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={OpenSearchCondition.class})
public class ProcessInstanceArchiverJobOpenSearch
extends AbstractArchiverJobOpenSearch
implements ProcessInstanceArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstanceArchiverJobOpenSearch.class);
    @Autowired
    private FlowNodeInstanceIndex flowNodeInstanceIndex;
    @Autowired
    private VariableIndex variableIndex;
    @Autowired
    private ProcessInstanceIndex processInstanceIndex;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistOsAsyncClient")
    private OpenSearchAsyncClient openSearchAsyncClient;
    @Autowired
    private Metrics metrics;

    public ProcessInstanceArchiverJobOpenSearch(List<Integer> partitionIds) {
        super(partitionIds);
    }

    @Override
    public CompletableFuture<Map.Entry<String, Integer>> archiveBatch(AbstractArchiverJob.ArchiveBatch archiveBatch) {
        CompletableFuture<Map.Entry<String, Integer>> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following batch operations are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            CompletableFuture<Long> deleteVariablesFuture = this.archiverUtil.deleteDocuments(this.variableIndex.getFullQualifiedName(), "processInstanceId", archiveBatch.getIds());
            CompletableFuture<Long> deleteFlowNodesFuture = this.archiverUtil.deleteDocuments(this.flowNodeInstanceIndex.getFullQualifiedName(), "processInstanceId", archiveBatch.getIds());
            CompletableFuture<Long> deleteProcessInstanceFuture = this.archiverUtil.deleteDocuments(this.processInstanceIndex.getFullQualifiedName(), "id", archiveBatch.getIds());
            ((CompletableFuture)CompletableFuture.allOf(deleteVariablesFuture, deleteFlowNodesFuture, deleteProcessInstanceFuture).thenAccept(v -> archiveBatchFuture.complete(Map.entry("PROCESS_INSTANCE_ARCHIVER", archiveBatch.getIds().size())))).exceptionally(t -> {
                archiveBatchFuture.completeExceptionally((Throwable)t);
                return null;
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(Map.entry("NothingToArchive", 0));
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<AbstractArchiverJob.ArchiveBatch> getNextBatch() {
        CompletableFuture<AbstractArchiverJob.ArchiveBatch> nextBatchFuture = new CompletableFuture<AbstractArchiverJob.ArchiveBatch>();
        SearchRequest searchRequest = this.createFinishedProcessInstanceSearchRequest();
        Timer.Sample startTimer = Timer.start();
        this.sendSearchRequest(searchRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, AbstractArchiverJob.ArchiveBatch> result = this.handleSearchResponse((SearchResponse)response, (Throwable)e);
            result.ifRightOrLeft(nextBatchFuture::complete, nextBatchFuture::completeExceptionally);
        });
        return nextBatchFuture;
    }

    protected Either<Throwable, AbstractArchiverJob.ArchiveBatch> handleSearchResponse(SearchResponse searchResponse, Throwable error) {
        if (error != null) {
            String message = String.format("Exception occurred, while obtaining finished process instances: %s", error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        AbstractArchiverJob.ArchiveBatch batch = this.createArchiveBatch(searchResponse);
        return Either.right((Object)batch);
    }

    protected AbstractArchiverJob.ArchiveBatch createArchiveBatch(SearchResponse response) {
        HitsMetadata hits = response.hits();
        if (!hits.hits().isEmpty()) {
            List<String> ids = hits.hits().stream().map(Hit::id).collect(Collectors.toList());
            return new AbstractArchiverJob.ArchiveBatch(ids);
        }
        return null;
    }

    private SearchRequest createFinishedProcessInstanceSearchRequest() {
        List partitions = this.getPartitionIds().stream().map(m -> FieldValue.of((long)m.intValue())).collect(Collectors.toList());
        Query.Builder endDateQ = new Query.Builder();
        endDateQ.range(r -> r.field("endDate").lte(JsonData.of((Object)this.tasklistProperties.getArchiver().getArchivingTimepoint())));
        Query.Builder partitionQ = new Query.Builder();
        partitionQ.terms(t -> t.field("partitionId").terms(terms -> terms.value(partitions)));
        Query q = (Query)new Query.Builder().constantScore(cs -> cs.filter(OpenSearchUtil.joinWithAnd((ObjectBuilder[])new ObjectBuilder[]{endDateQ, partitionQ}))).build();
        SearchRequest searchRequest = new SearchRequest.Builder().query(q).size(Integer.valueOf(this.tasklistProperties.getArchiver().getRolloverBatchSize())).sort(s -> s.field(f -> f.field("endDate").order(SortOrder.Asc))).requestCache(Boolean.valueOf(false)).scroll(Time.of(t -> t.time("60000ms"))).build();
        LOGGER.debug("Query finished process instances for archiving request: \n{}", (Object)q.toString());
        return searchRequest;
    }

    private Timer getArchiverQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.query", new String[0]);
    }
}

