/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.os;

import io.camunda.tasklist.archiver.ArchiverUtilAbstract;
import io.camunda.tasklist.data.conditionals.OpenSearchCondition;
import io.camunda.tasklist.exceptions.ArchiverException;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.micrometer.core.instrument.Timer;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.opensearch.client.Request;
import org.opensearch.client.Response;
import org.opensearch.client.RestClient;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch._types.Conflicts;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.Time;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.ReindexResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={OpenSearchCondition.class})
public class ArchiverUtilOpenSearch
extends ArchiverUtilAbstract {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchiverUtilOpenSearch.class);
    @Autowired
    @Qualifier(value="tasklistOsRestClient")
    private RestClient opensearchRestClient;
    @Autowired
    @Qualifier(value="tasklistOsAsyncClient")
    private OpenSearchAsyncClient osClient;

    @Override
    public CompletableFuture<Long> deleteDocuments(String sourceIndexName, String idFieldName, List<String> processInstanceKeys) {
        CompletableFuture<Long> deleteFuture = new CompletableFuture<Long>();
        DeleteByQueryRequest deleteRequest = this.createDeleteByQueryRequestWithDefaults(sourceIndexName).query(q -> q.terms(t -> t.field(idFieldName).terms(terms -> terms.value(processInstanceKeys.stream().map(p -> FieldValue.of((String)p)).collect(Collectors.toList()))))).build();
        Timer.Sample startTimer = Timer.start();
        this.sendDeleteRequest(deleteRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverDeleteQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, Long> result = this.handleDeleteByQueryResponse((DeleteByQueryResponse)response, (Throwable)e, sourceIndexName, "delete");
            result.ifRightOrLeft(deleteFuture::complete, deleteFuture::completeExceptionally);
        });
        return deleteFuture;
    }

    @Override
    public CompletableFuture<Long> reindexDocuments(String sourceIndexName, String destinationIndexName, String idFieldName, List<String> processInstanceKeys) {
        CompletableFuture<Long> reindexFuture = new CompletableFuture<Long>();
        ReindexRequest reindexRequest = this.createReindexRequestWithDefaults().source(s -> s.query(q -> q.terms(t -> t.field(idFieldName).terms(tv -> tv.value(processInstanceKeys.stream().map(m -> FieldValue.of((String)m)).collect(Collectors.toList()))))).index(List.of(sourceIndexName))).dest(d -> d.index(destinationIndexName)).build();
        Timer.Sample startTimer = Timer.start();
        this.sendReindexRequest(reindexRequest).whenComplete((response, e) -> {
            Timer reindexTimer = this.getArchiverReindexQueryTimer();
            startTimer.stop(reindexTimer);
            Either<Throwable, Long> result = this.handleReindexResponse((ReindexResponse)response, (Throwable)e, sourceIndexName, "reindex");
            result.ifRightOrLeft(reindexFuture::complete, reindexFuture::completeExceptionally);
        });
        return reindexFuture;
    }

    @Override
    public void setIndexLifeCycle(String destinationIndexName) {
        if (this.tasklistProperties.getArchiver().isIlmEnabled()) {
            try {
                Request request = new Request("POST", "/_plugins/_ism/add/" + destinationIndexName);
                JsonObject requestJson = Json.createObjectBuilder().add("policy_id", (JsonValue)Json.createValue((String)"tasklist_delete_archived_indices")).build();
                request.setJsonEntity(requestJson.toString());
                Response response = this.opensearchRestClient.performRequest(request);
            }
            catch (IOException e) {
                LOGGER.warn("Could not set ILM policy {} for index {}: {}", new Object[]{"tasklist_delete_archived_indices", destinationIndexName, e.getMessage()});
            }
        }
    }

    private CompletableFuture<ReindexResponse> sendReindexRequest(ReindexRequest reindexRequest) {
        return OpenSearchUtil.reindexAsync((ReindexRequest)reindexRequest, (Executor)this.archiverExecutor, (OpenSearchAsyncClient)this.osClient);
    }

    private ReindexRequest.Builder createReindexRequestWithDefaults() {
        ReindexRequest.Builder reindexRequest = new ReindexRequest.Builder();
        return reindexRequest.scroll(Time.of(t -> t.time("30000ms"))).conflicts(Conflicts.Proceed).slices(Long.valueOf(0L));
    }

    private DeleteByQueryRequest.Builder createDeleteByQueryRequestWithDefaults(String index) {
        DeleteByQueryRequest.Builder deleteRequest = new DeleteByQueryRequest.Builder().index(index, new String[0]);
        return deleteRequest.scroll(Time.of(t -> t.time("30000ms"))).slices(Long.valueOf(0L)).conflicts(Conflicts.Proceed);
    }

    private CompletableFuture<DeleteByQueryResponse> sendDeleteRequest(DeleteByQueryRequest deleteRequest) {
        return OpenSearchUtil.deleteByQueryAsync((DeleteByQueryRequest)deleteRequest, (Executor)this.archiverExecutor, (OpenSearchAsyncClient)this.osClient);
    }

    private Either<Throwable, Long> handleReindexResponse(ReindexResponse response, Throwable error, String sourceIndexName, String operation) {
        if (error != null) {
            String message = String.format("Exception occurred, while performing operation %s on source index %s. the documents: %s", operation, sourceIndexName, error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        List bulkFailures = response.failures();
        if (bulkFailures.size() > 0) {
            LOGGER.error("Failures occurred when performing operation: {} on source index {}. See details below.", (Object)operation, (Object)sourceIndexName);
            bulkFailures.stream().forEach(f -> LOGGER.error(f.toString()));
            return Either.left((Object)new ArchiverException(String.format("Operation % failed", operation)));
        }
        LOGGER.debug("Operation {} succeded on source index {}. Response: {}", new Object[]{operation, sourceIndexName, response.toString()});
        return Either.right((Object)response.total());
    }

    private Either<Throwable, Long> handleDeleteByQueryResponse(DeleteByQueryResponse response, Throwable error, String sourceIndexName, String operation) {
        if (error != null) {
            String message = String.format("Exception occurred, while performing operation %s on source index %s. the documents: %s", operation, sourceIndexName, error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        List bulkFailures = response.failures();
        if (bulkFailures.size() > 0) {
            LOGGER.error("Failures occurred when performing operation: {} on source index {}. See details below.", (Object)operation, (Object)sourceIndexName);
            bulkFailures.stream().forEach(f -> LOGGER.error(f.toString()));
            return Either.left((Object)new ArchiverException(String.format("Operation % failed", operation)));
        }
        LOGGER.debug("Operation {} succeded on source index {}. Response: {}", new Object[]{operation, sourceIndexName, response.toString()});
        return Either.right((Object)response.total());
    }

    private Timer getArchiverReindexQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.reindex.query", new String[0]);
    }

    private Timer getArchiverDeleteQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.delete.query", new String[0]);
    }
}

