/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver.es;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.archiver.AbstractArchiverJob;
import io.camunda.tasklist.archiver.TaskArchiverJob;
import io.camunda.tasklist.archiver.es.AbstractArchiverJobElasticSearch;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.templates.TaskTemplate;
import io.camunda.tasklist.schema.templates.TaskVariableTemplate;
import io.camunda.tasklist.util.Either;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
@Conditional(value={ElasticSearchCondition.class})
public class TaskArchiverJobElasticSearch
extends AbstractArchiverJobElasticSearch
implements TaskArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskArchiverJobElasticSearch.class);
    private static final String DATES_AGG = "datesAgg";
    private static final String INSTANCES_AGG = "instancesAgg";
    @Autowired
    private TaskTemplate taskTemplate;
    @Autowired
    private TaskVariableTemplate taskVariableTemplate;
    @Autowired
    private TasklistProperties tasklistProperties;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private Metrics metrics;

    public TaskArchiverJobElasticSearch(List<Integer> partitionIds) {
        super(partitionIds);
    }

    @Override
    public CompletableFuture<Map.Entry<String, Integer>> archiveBatch(AbstractArchiverJob.ArchiveBatch archiveBatch) {
        CompletableFuture<Map.Entry<String, Integer>> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following batch operations are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            CompletableFuture<Void> moveVariableDocuments = this.archiverUtil.moveDocuments(this.taskVariableTemplate.getFullQualifiedName(), "taskId", archiveBatch.getFinishDate(), archiveBatch.getIds());
            CompletableFuture<Void> moveTaskDocuments = this.archiverUtil.moveDocuments(this.taskTemplate.getFullQualifiedName(), "id", archiveBatch.getFinishDate(), archiveBatch.getIds());
            ((CompletableFuture)CompletableFuture.allOf(moveVariableDocuments, moveTaskDocuments).thenAccept(v -> archiveBatchFuture.complete(Map.entry(archiveBatch.getFinishDate(), archiveBatch.getIds().size())))).exceptionally(t -> {
                archiveBatchFuture.completeExceptionally((Throwable)t);
                return null;
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(Map.entry("NothingToArchive", 0));
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<AbstractArchiverJob.ArchiveBatch> getNextBatch() {
        CompletableFuture<AbstractArchiverJob.ArchiveBatch> batchFuture = new CompletableFuture<AbstractArchiverJob.ArchiveBatch>();
        AggregationBuilder aggregation = this.createFinishedTasksAggregation(DATES_AGG, INSTANCES_AGG);
        SearchRequest searchRequest = this.createFinishedTasksSearchRequest(aggregation);
        Timer.Sample startTimer = Timer.start();
        this.sendSearchRequest(searchRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, AbstractArchiverJob.ArchiveBatch> result = this.handleSearchResponse((SearchResponse)response, (Throwable)e);
            result.ifRightOrLeft(batchFuture::complete, batchFuture::completeExceptionally);
        });
        return batchFuture;
    }

    protected Either<Throwable, AbstractArchiverJob.ArchiveBatch> handleSearchResponse(SearchResponse searchResponse, Throwable error) {
        if (error != null) {
            String message = String.format("Exception occurred, while obtaining finished batch operations: %s", error.getMessage());
            return Either.left((Object)new TasklistRuntimeException(message, error));
        }
        AbstractArchiverJob.ArchiveBatch batch = this.createArchiveBatch(searchResponse);
        return Either.right((Object)batch);
    }

    private SearchRequest createFinishedTasksSearchRequest(AggregationBuilder agg) {
        RangeQueryBuilder endDateQ = QueryBuilders.rangeQuery((String)"completionTime").lte((Object)this.tasklistProperties.getArchiver().getArchivingTimepoint());
        TermsQueryBuilder partitionQ = QueryBuilders.termsQuery((String)"partitionId", this.getPartitionIds());
        ConstantScoreQueryBuilder q = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{endDateQ, partitionQ}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.taskTemplate.getFullQualifiedName()}).source(new SearchSourceBuilder().query((QueryBuilder)q).aggregation(agg).fetchSource(false).size(0).sort("completionTime", SortOrder.ASC)).requestCache(Boolean.valueOf(false));
        LOGGER.debug("Finished tasks for archiving request: \n{}\n and aggregation: \n{}", (Object)q.toString(), (Object)agg.toString());
        return searchRequest;
    }

    private AggregationBuilder createFinishedTasksAggregation(String datesAggName, String instancesAggName) {
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)datesAggName).field("completionTime")).calendarInterval(new DateHistogramInterval(Optional.ofNullable(this.tasklistProperties.getArchiver().getRolloverInterval()).orElse("1d"))).format(this.tasklistProperties.getArchiver().getElsRolloverDateFormat())).keyed(true).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"datesSortedAgg", Arrays.asList(new FieldSortBuilder("_key"))).size(Integer.valueOf(1)))).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)instancesAggName).size(this.tasklistProperties.getArchiver().getRolloverBatchSize()).sort("id", SortOrder.ASC).fetchSource("id", null));
    }

    protected AbstractArchiverJob.ArchiveBatch createArchiveBatch(SearchResponse searchResponse) {
        List buckets = ((Histogram)searchResponse.getAggregations().get(DATES_AGG)).getBuckets();
        if (buckets.size() > 0) {
            Histogram.Bucket bucket = (Histogram.Bucket)buckets.get(0);
            String finishDate = bucket.getKeyAsString();
            SearchHits hits = ((TopHits)bucket.getAggregations().get(INSTANCES_AGG)).getHits();
            ArrayList ids = Arrays.stream(hits.getHits()).collect(ArrayList::new, (list, hit) -> list.add(hit.getId()), (list1, list2) -> list1.addAll(list2));
            return new AbstractArchiverJob.ArchiveBatch(finishDate, ids);
        }
        return null;
    }

    private Timer getArchiverQueryTimer() {
        return this.metrics.getTimer("tasklist.archiver.query", new String[0]);
    }
}

