/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.archiver;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.archiver.ArchiverUtil;
import io.camunda.tasklist.property.TasklistProperties;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class ArchiverUtilAbstract
implements ArchiverUtil {
    private static final String INDEX_NAME_PATTERN = "%s%s";
    @Autowired
    @Qualifier(value="tasklistArchiverThreadPoolExecutor")
    protected ThreadPoolTaskScheduler archiverExecutor;
    @Autowired
    protected Metrics metrics;
    @Autowired
    protected TasklistProperties tasklistProperties;

    @Override
    public CompletableFuture<Void> moveDocuments(String sourceIndexName, String idFieldName, String finishDate, List<String> ids) {
        CompletableFuture<Void> moveDocumentsFuture = new CompletableFuture<Void>();
        String destinationIndexName = this.getDestinationIndexName(sourceIndexName, finishDate);
        ((CompletableFuture)this.reindexDocuments(sourceIndexName, destinationIndexName, idFieldName, ids).thenCompose(ignore -> {
            this.setIndexLifeCycle(destinationIndexName);
            return this.deleteDocuments(sourceIndexName, idFieldName, ids);
        })).whenComplete((ignore, e) -> {
            if (e != null) {
                moveDocumentsFuture.completeExceptionally((Throwable)e);
                return;
            }
            moveDocumentsFuture.complete(null);
        });
        return moveDocumentsFuture;
    }

    @Override
    public String getDestinationIndexName(String sourceIndexName, String finishDate) {
        return String.format(INDEX_NAME_PATTERN, sourceIndexName, finishDate);
    }

    @Override
    public abstract CompletableFuture<Long> deleteDocuments(String var1, String var2, List<String> var3);
}

