/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.bean;

import java.lang.annotation.Annotation;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.springframework.aop.support.AopUtils;
import org.springframework.util.ReflectionUtils;

public interface BeanInfo {
    public static Supplier<IllegalStateException> noAnnotationFound(Class<? extends Annotation> type) {
        return () -> new IllegalStateException("no annotation found - " + String.valueOf(type));
    }

    public Object getBean();

    public String getBeanName();

    default public Class<?> getTargetClass() {
        return AopUtils.getTargetClass((Object)this.getBean());
    }

    default public boolean hasClassAnnotation(Class<? extends Annotation> type) {
        return this.getTargetClass().isAnnotationPresent(type);
    }

    default public boolean hasMethodAnnotation(Class<? extends Annotation> type) {
        return Stream.of(ReflectionUtils.getAllDeclaredMethods(this.getTargetClass())).anyMatch(m -> m.isAnnotationPresent(type));
    }
}

