/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.http;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import io.camunda.operate.auth.Authentication;
import io.camunda.operate.exception.SdkException;
import io.camunda.operate.http.HttpClient;
import io.camunda.operate.http.TypeReferenceHttpClientResponseHandler;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Map<TypeReference<?>, String> endpointMap;
    private final CloseableHttpClient httpClient;
    private final Authentication authentication;
    private final ObjectMapper objectMapper;
    private final String baseUrl;

    public DefaultHttpClient(URL baseUrl, Authentication authentication, CloseableHttpClient httpClient, ObjectMapper objectMapper, Map<TypeReference<?>, String> endpointMap) {
        this.authentication = authentication;
        this.httpClient = httpClient;
        this.objectMapper = objectMapper.copy();
        this.endpointMap = endpointMap;
        this.objectMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.baseUrl = baseUrl.toString();
    }

    @Override
    public <T> T get(TypeReference<T> responseType, Map<String, String> pathParams) {
        String url = this.baseUrl + this.retrievePath(responseType, pathParams);
        HttpGet httpGet = new HttpGet(url);
        this.retrieveToken().forEach(arg_0 -> ((HttpGet)httpGet).addHeader(arg_0));
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)httpGet, this.handleResponse(responseType));
        }
        catch (Exception e) {
            throw new SdkException(String.format("Failed GET to %s, due to %s", url, e.getMessage()), e);
        }
    }

    @Override
    public <T, U> T post(TypeReference<T> responseType, U body) {
        String data;
        String url = this.baseUrl + this.retrievePath(responseType, Map.of());
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", (Object)"application/json");
        this.retrieveToken().forEach(arg_0 -> ((HttpPost)httpPost).addHeader(arg_0));
        try {
            data = this.objectMapper.writeValueAsString(body);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Error while parsing " + String.valueOf(body) + "of type " + String.valueOf(body.getClass()), e);
        }
        httpPost.setEntity((HttpEntity)new StringEntity(data));
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)httpPost, this.handleResponse(responseType));
        }
        catch (Exception e) {
            throw new SdkException(String.format("Failed POST to %s with body %s, due to %s", url, data, e.getMessage()), e);
        }
    }

    @Override
    public <T> T delete(TypeReference<T> responseType, Map<String, String> pathParams) {
        String resourcePath = this.retrievePath(responseType, pathParams);
        String url = this.baseUrl + resourcePath;
        HttpDelete httpDelete = new HttpDelete(url);
        this.retrieveToken().forEach(arg_0 -> ((HttpDelete)httpDelete).addHeader(arg_0));
        try {
            return (T)this.httpClient.execute((ClassicHttpRequest)httpDelete, this.handleResponse(responseType));
        }
        catch (Exception e) {
            throw new SdkException(String.format("Failed DELETE to %s, due to %s", url, e.getMessage()), e);
        }
    }

    private <T> String retrievePath(TypeReference<T> clazz, Map<String, String> pathParams) {
        AtomicReference<String> path = new AtomicReference<String>();
        if (this.endpointMap.containsKey(clazz)) {
            path.set(this.endpointMap.get(clazz));
        }
        for (String pathParam : pathParams.keySet()) {
            String pathParamMarker = "{" + pathParam + "}";
            if (!((String)path.get()).contains(pathParamMarker)) continue;
            path.set(((String)path.get()).replace(pathParamMarker, pathParams.get(pathParam)));
        }
        return (String)path.get();
    }

    private List<? extends Header> retrieveToken() {
        Map<String, String> header = this.authentication.getTokenHeader();
        return header.entrySet().stream().map(e -> new BasicHeader((String)e.getKey(), e.getValue())).toList();
    }

    private <T> HttpClientResponseHandler<T> handleResponse(TypeReference<T> responseType) {
        return new TypeReferenceHttpClientResponseHandler<T>(responseType, this.objectMapper, this::handleErrorResponse);
    }

    private SdkException handleErrorResponse(Integer code) {
        if (code == 401 || code == 403) {
            this.authentication.resetToken();
        }
        return new SdkException("Response not successful: " + code);
    }
}

