/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.zeebe.operation;

import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.BackoffIdleStrategy;
import io.camunda.operate.util.ThreadUtil;
import io.camunda.operate.webapp.writer.BatchOperationWriter;
import io.camunda.operate.webapp.zeebe.operation.ExecutionFinishedListener;
import io.camunda.operate.webapp.zeebe.operation.OperationCommand;
import io.camunda.operate.webapp.zeebe.operation.OperationHandler;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class OperationExecutor
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationExecutor.class);
    private boolean shutdown = false;
    private final int defaultBackoff = 2000;
    @Autowired
    private List<OperationHandler> handlers;
    @Autowired
    private BatchOperationWriter batchOperationWriter;
    @Autowired
    private OperateProperties operateProperties;
    private final BackoffIdleStrategy errorStrategy = new BackoffIdleStrategy(2000L, 1.2f, 10000L);
    @Autowired
    @Qualifier(value="operationsThreadPoolExecutor")
    private ThreadPoolTaskExecutor operationsTaskExecutor;
    private List<ExecutionFinishedListener> listeners = new ArrayList<ExecutionFinishedListener>();

    public void startExecuting() {
        if (this.operateProperties.getOperationExecutor().isExecutorEnabled()) {
            this.start();
        }
    }

    @PreDestroy
    public void shutdown() {
        LOGGER.info("Shutdown OperationExecutor");
        this.shutdown = true;
    }

    @Override
    public void run() {
        while (!this.shutdown) {
            try {
                List<Future<?>> operations = this.executeOneBatch();
                if (operations.size() != 0) continue;
                this.notifyExecutionFinishedListeners();
                this.errorStrategy.reset();
                ThreadUtil.sleepFor((long)2000L);
            }
            catch (Exception ex) {
                LOGGER.error("Something went wrong, while executing operations batch. Will be retried.", (Throwable)ex);
                this.errorStrategy.idle();
                ThreadUtil.sleepFor((long)this.errorStrategy.idleTime());
            }
        }
    }

    public List<Future<?>> executeOneBatch() throws PersistenceException {
        ArrayList futures = new ArrayList();
        List<OperationEntity> lockedOperations = this.batchOperationWriter.lockBatch();
        for (OperationEntity operation : lockedOperations) {
            OperationHandler handler = this.getOperationHandlers().get(operation.getType());
            if (handler == null) {
                LOGGER.info("Operation {} on worflowInstanceId {} won't be processed, as no suitable handler was found.", (Object)operation.getType(), (Object)operation.getProcessInstanceKey());
                continue;
            }
            OperationCommand operationCommand = new OperationCommand(operation, handler);
            futures.add(this.operationsTaskExecutor.submit((Runnable)operationCommand));
        }
        return futures;
    }

    @Bean
    public Map<OperationType, OperationHandler> getOperationHandlers() {
        HashMap<OperationType, OperationHandler> handlerMap = new HashMap<OperationType, OperationHandler>();
        for (OperationHandler handler : this.handlers) {
            handler.getTypes().forEach(t -> handlerMap.put((OperationType)t, handler));
        }
        return handlerMap;
    }

    public void registerListener(ExecutionFinishedListener listener) {
        this.listeners.add(listener);
    }

    private void notifyExecutionFinishedListeners() {
        for (ExecutionFinishedListener listener : this.listeners) {
            listener.onExecutionFinished();
        }
    }
}

