/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.auth;

import io.camunda.authentication.entity.CamundaUser;
import io.camunda.operate.webapp.rest.dto.UserDto;
import io.camunda.operate.webapp.security.AbstractUserService;
import io.camunda.operate.webapp.security.Permission;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"auth-basic"})
public class AuthBasicUserService
extends AbstractUserService<UsernamePasswordAuthenticationToken> {
    @Override
    public UserDto createUserDtoFrom(UsernamePasswordAuthenticationToken authentication) {
        CamundaUser camundaUser = (CamundaUser)authentication.getPrincipal();
        return new UserDto().setUserId(String.valueOf(camundaUser.getUserKey())).setDisplayName(camundaUser.getName()).setCanLogout(false).setPermissions(List.of(Permission.READ, Permission.WRITE));
    }

    @Override
    public String getUserToken(UsernamePasswordAuthenticationToken authentication) {
        throw new UnsupportedOperationException("Get token is not supported for basic authentication");
    }
}

