/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.validation;

import io.camunda.operate.entities.OperationType;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.reader.VariableReader;
import io.camunda.operate.webapp.rest.dto.operation.CreateOperationRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import java.util.Set;
import org.springframework.stereotype.Component;

@Component
public class CreateRequestOperationValidator {
    private final VariableReader variableReader;
    private final OperationReader operationReader;

    public CreateRequestOperationValidator(VariableReader variableReader, OperationReader operationReader) {
        this.variableReader = variableReader;
        this.operationReader = operationReader;
    }

    public void validate(CreateOperationRequestDto operationRequest, String processInstanceId) {
        if (operationRequest.getOperationType() == null) {
            throw new InvalidRequestException("Operation type must be defined.");
        }
        if (Set.of(OperationType.UPDATE_VARIABLE, OperationType.ADD_VARIABLE).contains(operationRequest.getOperationType()) && (operationRequest.getVariableScopeId() == null || operationRequest.getVariableName() == null || operationRequest.getVariableName().isEmpty() || operationRequest.getVariableValue() == null)) {
            throw new InvalidRequestException("ScopeId, name and value must be defined for UPDATE_VARIABLE operation.");
        }
        if (operationRequest.getOperationType().equals((Object)OperationType.ADD_VARIABLE) && (this.variableReader.getVariableByName(processInstanceId, operationRequest.getVariableScopeId(), operationRequest.getVariableName()) != null || !this.operationReader.getOperations(OperationType.ADD_VARIABLE, processInstanceId, operationRequest.getVariableScopeId(), operationRequest.getVariableName()).isEmpty())) {
            throw new InvalidRequestException(String.format("Variable with the name \"%s\" already exists.", operationRequest.getVariableName()));
        }
    }
}

