/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.metadata;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.entities.EventMetadataEntity;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeInstanceMetadata;
import java.time.OffsetDateTime;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FlowNodeInstanceMetadataDto
implements FlowNodeInstanceMetadata {
    private String flowNodeId;
    private String flowNodeInstanceId;
    private FlowNodeType flowNodeType;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private String eventId;
    private String messageName;
    private String correlationKey;

    public FlowNodeInstanceMetadataDto(String flowNodeId, String flowNodeInstanceId, FlowNodeType flowNodeType, OffsetDateTime startDate, OffsetDateTime endDate, EventEntity event) {
        this.flowNodeId = flowNodeId;
        this.flowNodeInstanceId = flowNodeInstanceId;
        this.flowNodeType = flowNodeType;
        this.startDate = startDate;
        this.endDate = endDate;
        this.eventId = event.getId();
        EventMetadataEntity eventMetadata = event.getMetadata();
        if (eventMetadata != null) {
            this.messageName = eventMetadata.getMessageName();
            this.correlationKey = eventMetadata.getCorrelationKey();
        }
    }

    public FlowNodeInstanceMetadataDto() {
    }

    @Override
    public FlowNodeType getFlowNodeType() {
        return this.flowNodeType;
    }

    @Override
    public FlowNodeInstanceMetadataDto setFlowNodeType(FlowNodeType flowNodeType) {
        this.flowNodeType = flowNodeType;
        return this;
    }

    @Override
    public String getFlowNodeInstanceId() {
        return this.flowNodeInstanceId;
    }

    @Override
    public FlowNodeInstanceMetadataDto setFlowNodeInstanceId(String flowNodeInstanceId) {
        this.flowNodeInstanceId = flowNodeInstanceId;
        return this;
    }

    @Override
    public String getFlowNodeId() {
        return this.flowNodeId;
    }

    @Override
    public FlowNodeInstanceMetadataDto setFlowNodeId(String flowNodeId) {
        this.flowNodeId = flowNodeId;
        return this;
    }

    @Override
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    @Override
    public FlowNodeInstanceMetadataDto setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Override
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    @Override
    public FlowNodeInstanceMetadataDto setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public FlowNodeInstanceMetadataDto setEventId(String eventId) {
        this.eventId = eventId;
        return this;
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public FlowNodeInstanceMetadataDto setMessageName(String messageName) {
        this.messageName = messageName;
        return this;
    }

    @Override
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public FlowNodeInstanceMetadataDto setCorrelationKey(String correlationKey) {
        this.correlationKey = correlationKey;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.flowNodeId, this.flowNodeInstanceId, this.flowNodeType, this.startDate, this.endDate, this.eventId, this.messageName, this.correlationKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowNodeInstanceMetadataDto that = (FlowNodeInstanceMetadataDto)o;
        return Objects.equals(this.flowNodeId, that.flowNodeId) && Objects.equals(this.flowNodeInstanceId, that.flowNodeInstanceId) && this.flowNodeType == that.flowNodeType && Objects.equals(this.startDate, that.startDate) && Objects.equals(this.endDate, that.endDate) && Objects.equals(this.eventId, that.eventId) && Objects.equals(this.messageName, that.messageName) && Objects.equals(this.correlationKey, that.correlationKey);
    }

    public String toString() {
        return "FlowNodeInstanceMetadataDto{flowNodeId='" + this.flowNodeId + "', flowNodeInstanceId='" + this.flowNodeInstanceId + "', flowNodeType=" + String.valueOf(this.flowNodeType) + ", startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", eventId='" + this.eventId + "', messageName='" + this.messageName + "', correlationKey='" + this.correlationKey + "'}";
    }
}

