/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.reader.FlowNodeInstanceReader;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceQueryDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceRequestDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeInstanceResponseDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.exception.NotAuthorizedException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Flow node instances")
@RestController
@RequestMapping(value={"/api/flow-node-instances"})
public class FlowNodeInstanceRestService
extends InternalAPIErrorController {
    public static final String FLOW_NODE_INSTANCE_URL = "/api/flow-node-instances";
    @Autowired(required=false)
    protected PermissionsService permissionsService;
    @Autowired
    private FlowNodeInstanceReader flowNodeInstanceReader;
    @Autowired
    private ProcessInstanceReader processInstanceReader;

    @Operation(summary="Query flow node instance tree. Returns map treePath <-> list of children.")
    @PostMapping
    public Map<String, FlowNodeInstanceResponseDto> queryFlowNodeInstanceTree(@RequestBody FlowNodeInstanceRequestDto request) {
        this.validateRequest(request);
        this.checkIdentityReadPermission(Long.parseLong(request.getQueries().get(0).getProcessInstanceId()));
        return this.flowNodeInstanceReader.getFlowNodeInstances(request);
    }

    private void validateRequest(FlowNodeInstanceRequestDto request) {
        if (request.getQueries() == null || request.getQueries().size() == 0) {
            throw new InvalidRequestException("At least one query must be provided when requesting for flow node instance tree.");
        }
        String processInstanceId = null;
        for (FlowNodeInstanceQueryDto query : request.getQueries()) {
            if (query == null || query.getProcessInstanceId() == null || query.getTreePath() == null) {
                throw new InvalidRequestException("Process instance id and tree path must be provided when requesting for flow node instance tree.");
            }
            if (CollectionUtil.countNonNullObjects((Object[])new Object[]{query.getSearchAfter(), query.getSearchAfterOrEqual(), query.getSearchBefore(), query.getSearchBeforeOrEqual()}) > 1L) {
                throw new InvalidRequestException("Only one of [searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual] must be present in request.");
            }
            if (processInstanceId == null) {
                processInstanceId = query.getProcessInstanceId();
                continue;
            }
            if (Objects.equals(processInstanceId, query.getProcessInstanceId())) continue;
            throw new InvalidRequestException("Process instance id must be the same for all the queries.");
        }
    }

    private void checkIdentityReadPermission(Long processInstanceKey) {
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForProcess(this.processInstanceReader.getProcessInstanceByKey(processInstanceKey).getBpmnProcessId(), IdentityPermission.READ)) {
            throw new NotAuthorizedException(String.format("No read permission for process instance %s", processInstanceKey));
        }
    }
}

