/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.dmn.DecisionInstanceEntity;
import io.camunda.operate.entities.dmn.DecisionInstanceState;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.DecisionInstanceTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.Tuple;
import io.camunda.operate.webapp.reader.DecisionInstanceReader;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.dmn.DRDDataEntryDto;
import io.camunda.operate.webapp.rest.dto.dmn.DecisionInstanceDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceForListDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListQueryDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListRequestDto;
import io.camunda.operate.webapp.rest.dto.dmn.list.DecisionInstanceListResponseDto;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchDecisionInstanceReader
implements DecisionInstanceReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchDecisionInstanceReader.class);
    private final DecisionInstanceTemplate decisionInstanceTemplate;
    private final DateTimeFormatter dateTimeFormatter;
    private final ObjectMapper objectMapper;
    private final OperateProperties operateProperties;
    private final PermissionsService permissionsService;
    private final RichOpenSearchClient richOpenSearchClient;

    public OpensearchDecisionInstanceReader(DecisionInstanceTemplate decisionInstanceTemplate, DateTimeFormatter dateTimeFormatter, ObjectMapper objectMapper, OperateProperties operateProperties, @Autowired(required=false) PermissionsService permissionsService, RichOpenSearchClient richOpenSearchClient) {
        this.decisionInstanceTemplate = decisionInstanceTemplate;
        this.dateTimeFormatter = dateTimeFormatter;
        this.objectMapper = objectMapper;
        this.operateProperties = operateProperties;
        this.permissionsService = permissionsService;
        this.richOpenSearchClient = richOpenSearchClient;
    }

    @Override
    public DecisionInstanceDto getDecisionInstance(String decisionInstanceId) {
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.decisionInstanceTemplate).query(QueryDSL.withTenantCheck((Query)QueryDSL.constantScore((Query)QueryDSL.and((Query[])new Query[]{QueryDSL.ids((String[])new String[]{decisionInstanceId}), QueryDSL.term((String)"id", (String)decisionInstanceId)}))));
        try {
            return DtoCreator.create((DecisionInstanceEntity)this.richOpenSearchClient.doc().searchUnique(searchRequest, DecisionInstanceEntity.class, decisionInstanceId), DecisionInstanceDto.class);
        }
        catch (NotFoundException e) {
            throw new io.camunda.operate.webapp.rest.exception.NotFoundException(e.getMessage());
        }
    }

    @Override
    public DecisionInstanceListResponseDto queryDecisionInstances(DecisionInstanceListRequestDto request) {
        DecisionInstanceListResponseDto result = new DecisionInstanceListResponseDto();
        List<DecisionInstanceEntity> entities = this.queryDecisionInstancesEntities(request, result);
        result.setDecisionInstances(DecisionInstanceForListDto.createFrom(entities, this.objectMapper));
        return result;
    }

    @Override
    public Map<String, List<DRDDataEntryDto>> getDecisionInstanceDRDData(String decisionInstanceId) {
        Long decisionInstanceKey = DecisionInstanceEntity.extractKey((String)decisionInstanceId);
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.decisionInstanceTemplate).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"key", (Long)decisionInstanceKey))).source(QueryDSL.sourceInclude((String[])new String[]{"decisionId", "state"}));
        ArrayList results = new ArrayList();
        this.richOpenSearchClient.doc().scrollWith(searchRequest, Map.class, hits -> hits.stream().filter(hit -> hit.source() != null).forEach(hit -> {
            Map map = (Map)hit.source();
            results.add(new DRDDataEntryDto(hit.id(), (String)map.get("decisionId"), DecisionInstanceState.valueOf((String)((String)map.get("state")))));
        }));
        return results.stream().collect(Collectors.groupingBy(DRDDataEntryDto::getDecisionId));
    }

    @Override
    public Tuple<String, String> getCalledDecisionInstanceAndDefinitionByFlowNodeInstanceId(String flowNodeInstanceId) {
        String[] calledDecisionInstanceId = new String[]{null};
        String[] calledDecisionDefinitionName = new String[]{null};
        this.findCalledDecisionInstance(flowNodeInstanceId, hit -> {
            String decisionDefId;
            DecisionInstanceEntity source = (DecisionInstanceEntity)hit.source();
            String rootDecisionDefId = source.getRootDecisionDefinitionId();
            if (rootDecisionDefId.equals(decisionDefId = source.getDecisionDefinitionId())) {
                calledDecisionInstanceId[0] = source.getId();
                String decisionName = source.getDecisionName();
                if (decisionName == null) {
                    decisionName = source.getDecisionId();
                }
                calledDecisionDefinitionName[0] = decisionName;
            } else {
                String decisionName = source.getRootDecisionName();
                if (decisionName == null) {
                    decisionName = source.getRootDecisionId();
                }
                calledDecisionDefinitionName[0] = decisionName;
            }
        });
        return Tuple.of((Object)calledDecisionInstanceId[0], (Object)calledDecisionDefinitionName[0]);
    }

    private List<DecisionInstanceEntity> queryDecisionInstancesEntities(DecisionInstanceListRequestDto request, DecisionInstanceListResponseDto result) {
        Query query = this.createRequestQuery(request.getQuery());
        LOGGER.debug("Decision instance search request: \n{}", (Object)query);
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((TemplateDescriptor)this.decisionInstanceTemplate).query(query).source(QueryDSL.sourceExclude((String[])new String[]{"result", "evaluatedInputs", "evaluatedOutputs"}));
        this.applySorting(searchRequest, request);
        LOGGER.debug("Search request will search in: \n{}", (Object)this.decisionInstanceTemplate.getFullQualifiedName());
        SearchResponse response = this.richOpenSearchClient.doc().search(searchRequest, DecisionInstanceEntity.class);
        result.setTotalCount(response.hits().total().value());
        ArrayList<DecisionInstanceEntity> decisionInstanceEntities = new ArrayList<DecisionInstanceEntity>(response.hits().hits().stream().filter(hit -> hit.source() != null).map(hit -> ((DecisionInstanceEntity)hit.source()).setSortValues(hit.sort().toArray())).toList());
        if (request.getSearchBefore() != null) {
            Collections.reverse(decisionInstanceEntities);
        }
        return decisionInstanceEntities;
    }

    private Query createRequestQuery(DecisionInstanceListQueryDto decisionInstanceListQueryDto) {
        Query query = QueryDSL.withTenantCheck((Query)QueryDSL.and((Query[])new Query[]{this.createEvaluatedFailedQuery(decisionInstanceListQueryDto), this.createDecisionDefinitionIdsQuery(decisionInstanceListQueryDto), this.createIdsQuery(decisionInstanceListQueryDto), this.createProcessInstanceIdQuery(decisionInstanceListQueryDto), this.createEvaluationDateQuery(decisionInstanceListQueryDto), this.createReadPermissionQuery(), this.createTenantIdQuery(decisionInstanceListQueryDto)}));
        return query == null ? QueryDSL.matchAll() : query;
    }

    private Query createTenantIdQuery(DecisionInstanceListQueryDto query) {
        if (query.getTenantId() != null) {
            return QueryDSL.term((String)"tenantId", (String)query.getTenantId());
        }
        return null;
    }

    private Query createReadPermissionQuery() {
        if (this.permissionsService == null) {
            return null;
        }
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getDecisionsWithPermission(IdentityPermission.READ);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryDSL.matchAll() : QueryDSL.stringTerms((String)"decisionId", allowed.getIds());
    }

    private Query createEvaluationDateQuery(DecisionInstanceListQueryDto decisionInstanceListQueryDto) {
        if (decisionInstanceListQueryDto.getEvaluationDateAfter() != null || decisionInstanceListQueryDto.getEvaluationDateBefore() != null) {
            RangeQuery query = RangeQuery.of(q -> {
                q.field("evaluationDate");
                if (decisionInstanceListQueryDto.getEvaluationDateAfter() != null) {
                    q.gte(JsonData.of((Object)this.dateTimeFormatter.format(decisionInstanceListQueryDto.getEvaluationDateAfter())));
                }
                if (decisionInstanceListQueryDto.getEvaluationDateBefore() != null) {
                    q.lt(JsonData.of((Object)this.dateTimeFormatter.format(decisionInstanceListQueryDto.getEvaluationDateBefore())));
                }
                q.format(this.operateProperties.getOpensearch().getDateFormat());
                return q;
            });
            return query._toQuery();
        }
        return null;
    }

    private Query createProcessInstanceIdQuery(DecisionInstanceListQueryDto query) {
        if (query.getProcessInstanceId() != null) {
            return QueryDSL.term((String)"processInstanceKey", (String)query.getProcessInstanceId());
        }
        return null;
    }

    private Query createIdsQuery(DecisionInstanceListQueryDto query) {
        if (CollectionUtil.isNotEmpty(query.getIds())) {
            return QueryDSL.stringTerms((String)"id", query.getIds());
        }
        return null;
    }

    private Query createDecisionDefinitionIdsQuery(DecisionInstanceListQueryDto query) {
        if (CollectionUtil.isNotEmpty(query.getDecisionDefinitionIds())) {
            return QueryDSL.stringTerms((String)"decisionDefinitionId", query.getDecisionDefinitionIds());
        }
        return null;
    }

    private Query createEvaluatedFailedQuery(DecisionInstanceListQueryDto query) {
        if (query.isEvaluated() && query.isFailed()) {
            return null;
        }
        if (query.isFailed()) {
            return QueryDSL.term((String)"state", (String)DecisionInstanceState.FAILED.name());
        }
        if (query.isEvaluated()) {
            return QueryDSL.term((String)"state", (String)DecisionInstanceState.EVALUATED.name());
        }
        return QueryDSL.matchNone();
    }

    private void applySorting(SearchRequest.Builder searchRequest, DecisionInstanceListRequestDto request) {
        Object[] querySearchAfter;
        SortOptions sort3;
        SortOptions sort2;
        boolean directSorting;
        String sortBy = this.getSortBy(request);
        boolean bl = directSorting = request.getSearchAfter() != null || request.getSearchBefore() == null;
        if (request.getSorting() != null) {
            SortOrder sort1DirectOrder = request.getSorting().getSortOrder().equalsIgnoreCase("desc") ? SortOrder.Desc : SortOrder.Asc;
            SortOptions sort1 = directSorting ? QueryDSL.sortOptions((String)sortBy, (SortOrder)sort1DirectOrder, (String)"_last") : QueryDSL.sortOptions((String)sortBy, (SortOrder)QueryDSL.reverseOrder((SortOrder)sort1DirectOrder), (String)"_first");
            searchRequest.sort(sort1, new SortOptions[0]);
        }
        if (directSorting) {
            sort2 = QueryDSL.sortOptions((String)"key", (SortOrder)SortOrder.Asc);
            sort3 = QueryDSL.sortOptions((String)"executionIndex", (SortOrder)SortOrder.Asc);
            querySearchAfter = request.getSearchAfter(this.objectMapper);
        } else {
            sort2 = QueryDSL.sortOptions((String)"key", (SortOrder)SortOrder.Desc);
            sort3 = QueryDSL.sortOptions((String)"executionIndex", (SortOrder)SortOrder.Desc);
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        }
        searchRequest.sort(sort2, new SortOptions[0]).sort(sort3, new SortOptions[0]).size(request.getPageSize());
        if (querySearchAfter != null) {
            searchRequest.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])querySearchAfter));
        }
    }

    private String getSortBy(DecisionInstanceListRequestDto request) {
        if (request.getSorting() != null) {
            String sortBy;
            sortBy = switch (sortBy = request.getSorting().getSortBy()) {
                case "id" -> "key";
                case "tenant" -> "tenantId";
                case "processInstanceId" -> "processInstanceKey";
                default -> sortBy;
            };
            return sortBy;
        }
        return null;
    }

    private void findCalledDecisionInstance(String flowNodeInstanceId, Consumer<Hit<DecisionInstanceEntity>> decisionInstanceConsumer) {
        SearchRequest.Builder searchRequest = RequestDSL.searchRequestBuilder((String)this.decisionInstanceTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"elementInstanceKey", (String)flowNodeInstanceId))).source(QueryDSL.sourceInclude((String[])new String[]{"rootDecisionDefinitionId", "rootDecisionName", "rootDecisionId", "decisionDefinitionId", "decisionName", "decisionId"})).sort(List.of(QueryDSL.sortOptions((String)"evaluationDate", (SortOrder)SortOrder.Desc), QueryDSL.sortOptions((String)"executionIndex", (SortOrder)SortOrder.Desc)));
        SearchResponse response = this.richOpenSearchClient.doc().search(searchRequest, DecisionInstanceEntity.class);
        if (response.hits().total().value() >= 1L) {
            decisionInstanceConsumer.accept((Hit<DecisionInstanceEntity>)((Hit)response.hits().hits().get(0)));
        }
    }
}

