/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.schema.indices.OperateWebSessionIndex;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.security.OperateSession;
import io.camunda.operate.webapp.security.SessionRepository;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpServletRequest;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchSessionRepository
implements SessionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchSessionRepository.class);
    private final RichOpenSearchClient richOpenSearchClient;
    private final GenericConversionService conversionService;
    private final OperateWebSessionIndex operateWebSessionIndex;
    private final HttpServletRequest request;

    public OpensearchSessionRepository(RichOpenSearchClient richOpenSearchClient, GenericConversionService conversionService, OperateWebSessionIndex operateWebSessionIndex, HttpServletRequest request) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.conversionService = conversionService;
        this.operateWebSessionIndex = operateWebSessionIndex;
        this.request = request;
    }

    @PostConstruct
    private void setUp() {
        this.setupConverter();
    }

    private void setupConverter() {
        this.conversionService.addConverter(Object.class, byte[].class, (Converter)new SerializingConverter());
        this.conversionService.addConverter(byte[].class, Object.class, (Converter)new DeserializingConverter());
    }

    private SessionEntity toSessionEntity(OperateSession session) {
        Map<String, String> attributes = session.getAttributeNames().stream().collect(Collectors.toMap(UnaryOperator.identity(), name -> this.serialize(session.getAttribute((String)name))));
        return new SessionEntity(session.getId(), session.getCreationTime().toEpochMilli(), session.getLastAccessedTime().toEpochMilli(), session.getMaxInactiveInterval().getSeconds(), attributes, session.isPolling());
    }

    private String serialize(Object object) {
        return new String(Base64.getEncoder().encode((byte[])this.conversionService.convert(object, TypeDescriptor.valueOf(Object.class), TypeDescriptor.valueOf(byte[].class))));
    }

    private OperateSession toOperateSession(SessionEntity sessionEntity) {
        OperateSession session = new OperateSession(sessionEntity.id());
        session.setCreationTime(this.nullable(sessionEntity.creationTime, Instant::ofEpochMilli));
        session.setLastAccessedTime(this.nullable(sessionEntity.lastAccessedTime, Instant::ofEpochMilli));
        session.setMaxInactiveInterval(this.nullable(sessionEntity.maxInactiveIntervalInSeconds, Duration::ofSeconds));
        if (sessionEntity.attributes() != null) {
            sessionEntity.attributes().forEach((key, value) -> session.setAttribute((String)key, this.deserialize((String)value)));
        }
        try {
            if (this.request != null && this.request.getHeader("x-is-polling") != null) {
                session.setPolling(true);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Expected Exception: is not possible to access request as currently this is not on a request context");
        }
        return session;
    }

    private Object deserialize(String s) {
        byte[] bytes = Base64.getDecoder().decode(s.getBytes());
        return this.conversionService.convert((Object)bytes, TypeDescriptor.valueOf(byte[].class), TypeDescriptor.valueOf(Object.class));
    }

    private <A, R> R nullable(A a, Function<A, R> f) {
        return a == null ? null : (R)f.apply(a);
    }

    @Override
    public List<String> getExpiredSessionIds() {
        return this.richOpenSearchClient.doc().scrollValues(RequestDSL.searchRequestBuilder((String)this.operateWebSessionIndex.getFullQualifiedName()), SessionEntity.class).stream().map(this::toOperateSession).filter(OperateSession::isExpired).map(OperateSession::getId).toList();
    }

    @Override
    public void save(OperateSession session) {
        IndexRequest.Builder requestBuilder = RequestDSL.indexRequestBuilder((String)this.operateWebSessionIndex.getFullQualifiedName()).id(session.getId()).document((Object)this.toSessionEntity(session));
        this.richOpenSearchClient.doc().indexWithRetries(requestBuilder);
    }

    @Override
    public Optional<OperateSession> findById(String id) {
        try {
            return this.richOpenSearchClient.doc().getWithRetries(this.operateWebSessionIndex.getFullQualifiedName(), id, SessionEntity.class).map(this::toOperateSession);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public void deleteById(String id) {
        this.richOpenSearchClient.doc().deleteWithRetries(this.operateWebSessionIndex.getFullQualifiedName(), id);
    }

    private record SessionEntity(String id, Long creationTime, Long lastAccessedTime, Long maxInactiveIntervalInSeconds, Map<String, String> attributes, Boolean polling) {
    }
}

