/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.EventTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.rest.exception.NotFoundException;
import java.io.IOException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticsearchCondition.class})
public class EventReader
implements io.camunda.operate.webapp.reader.EventReader {
    final EventTemplate eventTemplate;
    private final TenantAwareElasticsearchClient tenantAwareClient;
    private final ObjectMapper objectMapper;

    public EventReader(EventTemplate eventTemplate, TenantAwareElasticsearchClient tenantAwareClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.eventTemplate = eventTemplate;
        this.tenantAwareClient = tenantAwareClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public EventEntity getEventEntityByFlowNodeInstanceId(String flowNodeInstanceId) {
        EventEntity eventEntity;
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.termQuery((String)"flowNodeInstanceKey", (String)flowNodeInstanceId));
        SearchRequest request = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.eventTemplate).source(new SearchSourceBuilder().query((QueryBuilder)query).sort("id"));
        try {
            SearchResponse response = this.tenantAwareClient.search(request);
            if (response.getHits().getTotalHits().value < 1L) {
                throw new NotFoundException(String.format("Could not find flow node instance event with id '%s'.", flowNodeInstanceId));
            }
            eventEntity = (EventEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getHits()[(int)(response.getHits().getTotalHits().value - 1L)].getSourceAsString(), (ObjectMapper)this.objectMapper, EventEntity.class);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining metadata for flow node instance: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return eventEntity;
    }
}

