/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.api.v1.dao.elasticsearch;

import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.schema.templates.FlowNodeInstanceTemplate;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.api.v1.dao.FlowNodeInstanceDao;
import io.camunda.operate.webapp.api.v1.dao.elasticsearch.ElasticsearchDao;
import io.camunda.operate.webapp.api.v1.entities.FlowNodeInstance;
import io.camunda.operate.webapp.api.v1.entities.Query;
import io.camunda.operate.webapp.api.v1.entities.Results;
import io.camunda.operate.webapp.api.v1.exceptions.APIException;
import io.camunda.operate.webapp.api.v1.exceptions.ResourceNotFoundException;
import io.camunda.operate.webapp.api.v1.exceptions.ServerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component(value="ElasticsearchFlowNodeInstanceDaoV1")
public class ElasticsearchFlowNodeInstanceDao
extends ElasticsearchDao<FlowNodeInstance>
implements FlowNodeInstanceDao {
    @Autowired
    private FlowNodeInstanceTemplate flowNodeInstanceIndex;
    @Autowired
    private ProcessCache processCache;

    @Override
    protected void buildFiltering(Query<FlowNodeInstance> query, SearchSourceBuilder searchSourceBuilder) {
        FlowNodeInstance filter = query.getFilter();
        ArrayList<QueryBuilder> queryBuilders = new ArrayList<QueryBuilder>();
        if (filter != null) {
            queryBuilders.add(this.buildTermQuery("key", filter.getKey()));
            queryBuilders.add(this.buildTermQuery("processInstanceKey", filter.getProcessInstanceKey()));
            queryBuilders.add(this.buildTermQuery("processDefinitionKey", filter.getProcessDefinitionKey()));
            queryBuilders.add(this.buildMatchDateQuery("startDate", filter.getStartDate()));
            queryBuilders.add(this.buildMatchDateQuery("endDate", filter.getEndDate()));
            queryBuilders.add(this.buildTermQuery("state", filter.getState()));
            queryBuilders.add(this.buildTermQuery("type", filter.getType()));
            queryBuilders.add(this.buildTermQuery("flowNodeId", filter.getFlowNodeId()));
            queryBuilders.add(this.buildTermQuery("incident", filter.getIncident()));
            queryBuilders.add(this.buildTermQuery("incidentKey", filter.getIncidentKey()));
            queryBuilders.add(this.buildTermQuery("tenantId", filter.getTenantId()));
        }
        searchSourceBuilder.query(ElasticsearchUtil.joinWithAnd((QueryBuilder[])queryBuilders.toArray(new QueryBuilder[0])));
    }

    @Override
    public FlowNodeInstance byKey(Long key) throws APIException {
        List<FlowNodeInstance> flowNodeInstances;
        this.logger.debug("byKey {}", (Object)key);
        try {
            flowNodeInstances = this.searchFor(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (Object)key)));
        }
        catch (Exception e) {
            throw new ServerException(String.format("Error in reading flownode instance for key %s", key), e);
        }
        if (flowNodeInstances.isEmpty()) {
            throw new ResourceNotFoundException(String.format("No flownode instance found for key %s ", key));
        }
        if (flowNodeInstances.size() > 1) {
            throw new ServerException(String.format("Found more than one flownode instances for key %s", key));
        }
        return flowNodeInstances.get(0);
    }

    @Override
    public Results<FlowNodeInstance> search(Query<FlowNodeInstance> query) throws APIException {
        this.logger.debug("search {}", query);
        SearchSourceBuilder searchSourceBuilder = this.buildQueryOn(query, "key", new SearchSourceBuilder());
        try {
            SearchRequest searchRequest = new SearchRequest().indices(new String[]{this.flowNodeInstanceIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                Object[] sortValues = searchHitArray[searchHitArray.length - 1].getSortValues();
                List flowNodeInstances = ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, this::searchHitToFlowNodeInstance);
                return new Results().setTotal(searchHits.getTotalHits().value).setItems(flowNodeInstances).setSortValues(sortValues);
            }
            return new Results().setTotal(searchHits.getTotalHits().value);
        }
        catch (Exception e) {
            throw new ServerException("Error in reading flownode instances", e);
        }
    }

    private FlowNodeInstance searchHitToFlowNodeInstance(SearchHit searchHit) {
        Map searchHitAsMap = searchHit.getSourceAsMap();
        FlowNodeInstance flowNodeInstance = new FlowNodeInstance().setKey((Long)searchHitAsMap.get("key")).setProcessInstanceKey((Long)searchHitAsMap.get("processInstanceKey")).setProcessDefinitionKey((Long)searchHitAsMap.get("processDefinitionKey")).setStartDate(this.dateTimeFormatter.convertGeneralToApiDateTime((String)searchHitAsMap.get("startDate"))).setEndDate(this.dateTimeFormatter.convertGeneralToApiDateTime((String)searchHitAsMap.get("endDate"))).setType((String)searchHitAsMap.get("type")).setState((String)searchHitAsMap.get("state")).setFlowNodeId((String)searchHitAsMap.get("flowNodeId")).setIncident((Boolean)searchHitAsMap.get("incident")).setIncidentKey((Long)searchHitAsMap.get("incidentKey")).setTenantId((String)searchHitAsMap.get("tenantId"));
        if (flowNodeInstance.getFlowNodeId() != null) {
            String flowNodeName = this.processCache.getFlowNodeNameOrDefaultValue(flowNodeInstance.getProcessDefinitionKey(), flowNodeInstance.getFlowNodeId(), null);
            flowNodeInstance.setFlowNodeName(flowNodeName);
        }
        return flowNodeInstance;
    }

    protected List<FlowNodeInstance> searchFor(SearchSourceBuilder searchSourceBuilder) {
        try {
            SearchRequest searchRequest = new SearchRequest(new String[]{this.flowNodeInstanceIndex.getAlias()}).source(searchSourceBuilder);
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            SearchHits searchHits = searchResponse.getHits();
            SearchHit[] searchHitArray = searchHits.getHits();
            if (searchHitArray != null && searchHitArray.length > 0) {
                return ElasticsearchUtil.mapSearchHits((SearchHit[])searchHitArray, this::searchHitToFlowNodeInstance);
            }
            return List.of();
        }
        catch (Exception e) {
            throw new ServerException("Error in reading incidents", e);
        }
    }
}

