/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.sync;

import io.camunda.operate.opensearch.ExtendedOpenSearchClient;
import io.camunda.operate.store.opensearch.client.OpenSearchOperation;
import jakarta.json.stream.JsonGenerator;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.jsonb.JsonbJsonpMapper;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.transport.OpenSearchTransport;
import org.slf4j.Logger;

public class OpenSearchSyncOperation
extends OpenSearchOperation {
    protected OpenSearchClient openSearchClient;

    public OpenSearchSyncOperation(Logger logger, OpenSearchClient openSearchClient) {
        super(logger);
        this.openSearchClient = openSearchClient;
    }

    protected <R> R withExtendedOpenSearchClient(Function<ExtendedOpenSearchClient, R> f) {
        OpenSearchClient openSearchClient = this.openSearchClient;
        if (openSearchClient instanceof ExtendedOpenSearchClient) {
            ExtendedOpenSearchClient extendedOpenSearchClient = (ExtendedOpenSearchClient)openSearchClient;
            return f.apply(extendedOpenSearchClient);
        }
        throw new UnsupportedOperationException("ExtendedOpenSearchClient is required! Provided: " + this.openSearchClient.getClass().getName());
    }

    public String toJsonString(JsonpSerializable serializable) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (JsonGenerator generator = ((OpenSearchTransport)this.openSearchClient._transport()).jsonpMapper().jsonProvider().createGenerator((OutputStream)baos);){
            serializable.serialize(generator, (JsonpMapper)new JsonbJsonpMapper());
        }
        return baos.toString(StandardCharsets.UTF_8);
    }
}

