/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.client.async;

import io.camunda.operate.store.opensearch.client.async.OpenSearchAsyncOperation;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.opensearch.client.opensearch.OpenSearchAsyncClient;
import org.opensearch.client.opensearch.core.DeleteByQueryRequest;
import org.opensearch.client.opensearch.core.DeleteByQueryResponse;
import org.opensearch.client.opensearch.core.ScrollRequest;
import org.opensearch.client.opensearch.core.ScrollResponse;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.slf4j.Logger;

public class OpenSearchAsyncDocumentOperations
extends OpenSearchAsyncOperation {
    public OpenSearchAsyncDocumentOperations(Logger logger, OpenSearchAsyncClient openSearchAsyncClient) {
        super(logger, openSearchAsyncClient);
    }

    private CompletableFuture<ScrollResponse<Object>> scrollAsync(ScrollRequest scrollRequest, Function<Exception, String> errorMessageSupplier) {
        return this.safe(() -> this.openSearchAsyncClient.scroll(scrollRequest, Object.class), errorMessageSupplier);
    }

    public CompletableFuture<DeleteByQueryResponse> delete(DeleteByQueryRequest.Builder requestBuilder, Function<Exception, String> errorMessageSupplier) {
        return this.safe(() -> this.openSearchAsyncClient.deleteByQuery(requestBuilder.build()), errorMessageSupplier);
    }

    public <R> CompletableFuture<SearchResponse<R>> search(SearchRequest.Builder searchRequestBuilder, Class<R> clazz, Function<Exception, String> errorMessageSupplier) {
        return this.safe(() -> this.openSearchAsyncClient.search(searchRequestBuilder.build(), clazz), errorMessageSupplier);
    }
}

