/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.OperationStore;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.ExceptionHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.opensearch.client.opensearch._types.Refresh;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.IndexRequest;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.UpdateRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchOperationStore
implements OperationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchOperationStore.class);
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private OperationTemplate operationTemplate;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private BeanFactory beanFactory;

    @Override
    public Map<String, String> getIndexNameForAliasAndIds(String alias, Collection<String> ids) {
        return this.richOpenSearchClient.doc().getIndexNames(alias, ids);
    }

    @Override
    public List<OperationEntity> getOperationsFor(Long zeebeCommandKey, Long processInstanceKey, Long incidentKey, OperationType operationType) {
        if (processInstanceKey == null && zeebeCommandKey == null) {
            throw new OperateRuntimeException("Wrong call to search for operation. Not enough parameters.");
        }
        Query zeebeCommandKeyQ = zeebeCommandKey != null ? QueryDSL.term("zeebeCommandKey", zeebeCommandKey) : null;
        Query processInstanceKeyQ = processInstanceKey != null ? QueryDSL.term("processInstanceKey", processInstanceKey) : null;
        Query incidentKeyQ = incidentKey != null ? QueryDSL.term("incidentKey", incidentKey) : null;
        Query operationTypeQ = operationType != null ? QueryDSL.term("type", operationType.name()) : null;
        Query query = QueryDSL.and(zeebeCommandKeyQ, processInstanceKeyQ, incidentKeyQ, operationTypeQ, QueryDSL.stringTerms("state", List.of(OperationState.SENT.name(), OperationState.LOCKED.name())));
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.operationTemplate.getAlias()).query(query).size(Integer.valueOf(1));
        return this.richOpenSearchClient.doc().scrollValues(searchRequestBuilder, OperationEntity.class);
    }

    @Override
    public String add(BatchOperationEntity batchOperationEntity) throws PersistenceException {
        IndexRequest.Builder indexRequestBuilder = RequestDSL.indexRequestBuilder(this.batchOperationTemplate.getFullQualifiedName()).id(batchOperationEntity.getId()).document((Object)batchOperationEntity);
        ExceptionHelper.withPersistenceException(() -> this.richOpenSearchClient.doc().index(indexRequestBuilder));
        return batchOperationEntity.getId();
    }

    @Override
    public void update(OperationEntity operation, boolean refreshImmediately) throws PersistenceException {
        Function<Exception, String> errorMessageSupplier = e -> String.format("Error preparing the query to update operation [%s] for process instance id [%s]", operation.getId(), operation.getProcessInstanceKey());
        UpdateRequest.Builder updateRequestBuilder = RequestDSL.updateRequestBuilder(this.operationTemplate.getFullQualifiedName()).id(operation.getId()).doc((Object)operation).retryOnConflict(Integer.valueOf(3));
        if (refreshImmediately) {
            updateRequestBuilder.refresh(Refresh.True);
        }
        ExceptionHelper.withPersistenceException(() -> this.richOpenSearchClient.doc().update(updateRequestBuilder, errorMessageSupplier));
    }

    @Override
    public void updateWithScript(String index, String id, String script, Map<String, Object> parameters) {
        Function<Exception, String> errorMessageSupplier = e -> String.format("Exception occurred, while executing update request with script for operation [%s]", id);
        UpdateRequest.Builder updateRequestBuilder = RequestDSL.updateRequestBuilder(index).id(id).script(QueryDSL.script(script, parameters)).retryOnConflict(Integer.valueOf(3));
        this.richOpenSearchClient.doc().update(updateRequestBuilder, errorMessageSupplier);
    }

    @Override
    public BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }
}

