/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ExceptionHelper;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchListViewStore
implements ListViewStore {
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public Map<Long, String> getListViewIndicesForProcessInstances(List<Long> processInstanceIds) throws IOException {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate, RequestDSL.QueryType.ALL).query(QueryDSL.withTenantCheck(QueryDSL.ids(CollectionUtil.toSafeListOfStrings((Collection)CollectionUtil.map(processInstanceIds, Object::toString)))));
        Map processInstanceId2IndexName = ExceptionHelper.withIOException(() -> this.richOpenSearchClient.doc().search(searchRequestBuilder, Void.class).hits().hits().stream().collect(Collectors.toMap(hit -> Long.valueOf(hit.id()), Hit::index)));
        if (processInstanceId2IndexName.isEmpty()) {
            throw new NotFoundException(String.format("Process instances %s doesn't exists.", processInstanceIds));
        }
        return processInstanceId2IndexName;
    }

    @Override
    public String findProcessInstanceTreePathFor(long processInstanceKey) {
        RequestDSL.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? RequestDSL.QueryType.ALL : RequestDSL.QueryType.ONLY_RUNTIME;
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate, queryType).query(QueryDSL.withTenantCheck(QueryDSL.term("key", processInstanceKey))).source(QueryDSL.sourceInclude("treePath"));
        record Result(String treePath) {
        }
        List hits = this.richOpenSearchClient.doc().search(searchRequestBuilder, Result.class).hits().hits();
        if (hits.size() > 0) {
            return ((Result)((Hit)hits.get(0)).source()).treePath();
        }
        return null;
    }

    @Override
    public List<Long> getProcessInstanceKeysWithEmptyProcessVersionFor(Long processDefinitionKey) {
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder(this.listViewTemplate.getAlias()).query(QueryDSL.withTenantCheck(QueryDSL.constantScore(QueryDSL.and(QueryDSL.term("processDefinitionKey", processDefinitionKey), QueryDSL.not(QueryDSL.exists("processVersion")))))).source(s -> s.fetch(Boolean.valueOf(false)));
        return this.richOpenSearchClient.doc().search(searchRequestBuilder, Void.class).hits().hits().stream().map(hit -> Long.valueOf(hit.id())).toList();
    }
}

