/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.SequenceFlowEntity;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.SequenceFlowTemplate;
import io.camunda.operate.store.SequenceFlowStore;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchSequenceFlowStore
implements SequenceFlowStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchSequenceFlowStore.class);
    @Autowired
    private SequenceFlowTemplate sequenceFlowTemplate;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public List<SequenceFlowEntity> getSequenceFlowsByProcessInstanceKey(Long processInstanceKey) {
        TermQueryBuilder processInstanceKeyQuery = QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey);
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)processInstanceKeyQuery);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.sequenceFlowTemplate, ElasticsearchUtil.QueryType.ALL).source(new SearchSourceBuilder().query((QueryBuilder)query).sort("activityId", SortOrder.ASC));
        try {
            return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll(searchRequest, SequenceFlowEntity.class, this.objectMapper, this.esClient));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining sequence flows: %s for processInstanceKey %s", e.getMessage(), processInstanceKey);
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

