/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.entities.OperationState;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.store.OperationStore;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchOperationStore
implements OperationStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchOperationStore.class);
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private OperationTemplate operationTemplate;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private BeanFactory beanFactory;

    @Override
    public Map<String, String> getIndexNameForAliasAndIds(String alias, Collection<String> ids) {
        return ElasticsearchUtil.getIndexNames(alias, ids, this.esClient);
    }

    @Override
    public List<OperationEntity> getOperationsFor(Long zeebeCommandKey, Long processInstanceKey, Long incidentKey, OperationType operationType) {
        if (processInstanceKey == null && zeebeCommandKey == null) {
            throw new OperateRuntimeException("Wrong call to search for operation. Not enough parameters.");
        }
        TermQueryBuilder zeebeCommandKeyQ = zeebeCommandKey != null ? QueryBuilders.termQuery((String)"zeebeCommandKey", (Object)zeebeCommandKey) : null;
        TermQueryBuilder processInstanceKeyQ = processInstanceKey != null ? QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey) : null;
        TermQueryBuilder incidentKeyQ = incidentKey != null ? QueryBuilders.termQuery((String)"incidentKey", (Object)incidentKey) : null;
        TermQueryBuilder operationTypeQ = operationType != null ? QueryBuilders.termQuery((String)"type", (String)operationType.name()) : null;
        QueryBuilder query = ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{zeebeCommandKeyQ, processInstanceKeyQ, incidentKeyQ, operationTypeQ, QueryBuilders.termsQuery((String)"state", (String[])new String[]{OperationState.SENT.name(), OperationState.LOCKED.name()})});
        SearchRequest searchRequest = new SearchRequest(new String[]{this.operationTemplate.getAlias()}).source(new SearchSourceBuilder().query(query).size(1));
        try {
            return ElasticsearchUtil.scroll(searchRequest, OperationEntity.class, this.objectMapper, this.esClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the operations: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public String add(BatchOperationEntity batchOperationEntity) throws PersistenceException {
        try {
            IndexRequest indexRequest = new IndexRequest(this.batchOperationTemplate.getFullQualifiedName()).id(batchOperationEntity.getId()).source(this.objectMapper.writeValueAsString((Object)batchOperationEntity), XContentType.JSON);
            this.esClient.index(indexRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            LOGGER.error("Error persisting batch operation", (Throwable)e);
            throw new PersistenceException(String.format("Error persisting batch operation of type [%s]", new Object[]{batchOperationEntity.getType()}), (Throwable)e);
        }
        return batchOperationEntity.getId();
    }

    @Override
    public void update(OperationEntity operation, boolean refreshImmediately) throws PersistenceException {
        try {
            Map jsonMap = (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)operation), HashMap.class);
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(this.operationTemplate.getFullQualifiedName())).id(operation.getId()).doc(jsonMap).retryOnConflict(3);
            if (refreshImmediately) {
                updateRequest = updateRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            }
            this.esClient.update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (IOException e) {
            throw new PersistenceException(String.format("Error preparing the query to update operation [%s] for process instance id [%s]", operation.getId(), operation.getProcessInstanceKey()), (Throwable)e);
        }
    }

    @Override
    public void updateWithScript(String index, String id, String script, Map<String, Object> parameters) {
        try {
            UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).script(this.getScriptWithParameters(script, parameters)).retryOnConflict(3);
            this.esClient.update(updateRequest, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            String message = String.format("Exception occurred, while executing update request: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public BatchRequest newBatchRequest() {
        return (BatchRequest)this.beanFactory.getBean(BatchRequest.class);
    }

    private Script getScriptWithParameters(String script, Map<String, Object> parameters) throws PersistenceException {
        try {
            return new Script(ScriptType.INLINE, "painless", script, (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(parameters), HashMap.class));
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

