/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.store.ListViewStore;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchListViewStore
implements ListViewStore {
    @Autowired
    private ListViewTemplate listViewTemplate;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public Map<Long, String> getListViewIndicesForProcessInstances(List<Long> processInstanceIds) throws IOException {
        List processInstanceIdsAsStrings = CollectionUtil.map(processInstanceIds, Object::toString);
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, ElasticsearchUtil.QueryType.ALL);
        searchRequest.source().query((QueryBuilder)QueryBuilders.idsQuery().addIds(CollectionUtil.toSafeArrayOfStrings((Collection)processInstanceIdsAsStrings)));
        HashMap<Long, String> processInstanceId2IndexName = new HashMap<Long, String>();
        this.tenantAwareClient.search(searchRequest, () -> {
            ElasticsearchUtil.scrollWith(searchRequest, this.esClient, searchHits -> {
                for (SearchHit searchHit : searchHits.getHits()) {
                    String indexName = searchHit.getIndex();
                    Long id = Long.valueOf(searchHit.getId());
                    processInstanceId2IndexName.put(id, indexName);
                }
            });
            return null;
        });
        if (processInstanceId2IndexName.isEmpty()) {
            throw new NotFoundException(String.format("Process instances %s doesn't exists.", processInstanceIds));
        }
        return processInstanceId2IndexName;
    }

    @Override
    public String findProcessInstanceTreePathFor(long processInstanceKey) {
        ElasticsearchUtil.QueryType queryType = this.operateProperties.getImporter().isReadArchivedParents() ? ElasticsearchUtil.QueryType.ALL : ElasticsearchUtil.QueryType.ONLY_RUNTIME;
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.listViewTemplate, queryType).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"key", (long)processInstanceKey)).fetchSource("treePath", null));
        try {
            SearchHits hits = this.tenantAwareClient.search(searchRequest).getHits();
            if (hits.getTotalHits().value > 0L) {
                return (String)hits.getHits()[0].getSourceAsMap().get("treePath");
            }
            return null;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while searching for process instance tree path: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<Long> getProcessInstanceKeysWithEmptyProcessVersionFor(Long processDefinitionKey) {
        ConstantScoreQueryBuilder queryBuilder = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"processDefinitionKey", (Object)processDefinitionKey), QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"processVersion"))}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.listViewTemplate.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)queryBuilder).fetchSource(false));
        try {
            return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scrollKeysToList(searchRequest, this.esClient));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining process instance that has empty versions: %s", e.getMessage());
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

