/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.IncidentState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.store.IncidentStore;
import io.camunda.operate.store.NotFoundException;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchIncidentStore
implements IncidentStore {
    public static final QueryBuilder ACTIVE_INCIDENT_QUERY = QueryBuilders.termQuery((String)"state", (Object)((Object)IncidentState.ACTIVE));
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchIncidentStore.class);
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    private TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public IncidentEntity getIncidentById(Long incidentKey) {
        IdsQueryBuilder idsQ = QueryBuilders.idsQuery().addIds(new String[]{incidentKey.toString()});
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{idsQ, ACTIVE_INCIDENT_QUERY}));
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.incidentTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)query));
        try {
            SearchResponse response = this.tenantAwareClient.search(searchRequest);
            if (response.getHits().getTotalHits().value == 1L) {
                return ElasticsearchUtil.fromSearchHit(response.getHits().getHits()[0].getSourceAsString(), this.objectMapper, IncidentEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundException(String.format("Could not find unique incident with key '%s'.", incidentKey));
            }
            throw new NotFoundException(String.format("Could not find incident with key '%s'.", incidentKey));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incident: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<IncidentEntity> getIncidentsWithErrorTypesFor(String treePath, List<Map<ErrorType, Long>> errorTypes) {
        TermQueryBuilder processInstanceQuery = QueryBuilders.termQuery((String)"treePath", (String)treePath);
        String errorTypesAggName = "errorTypesAgg";
        TermsAggregationBuilder errorTypesAgg = ((TermsAggregationBuilder)AggregationBuilders.terms((String)"errorTypesAgg").field("errorType")).size(ErrorType.values().length).order(BucketOrder.key((boolean)true));
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.incidentTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{processInstanceQuery, ACTIVE_INCIDENT_QUERY}))).aggregation((AggregationBuilder)errorTypesAgg));
        try {
            return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll(searchRequest, IncidentEntity.class, this.objectMapper, this.esClient, null, aggs -> ((Terms)aggs.get("errorTypesAgg")).getBuckets().forEach(b -> {
                ErrorType errorType = ErrorType.valueOf(b.getKeyAsString());
                errorTypes.add(Map.of(errorType, b.getDocCount()));
            })));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incidents: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public List<IncidentEntity> getIncidentsByProcessInstanceKey(Long processInstanceKey) {
        TermQueryBuilder processInstanceKeyQuery = QueryBuilders.termQuery((String)"processInstanceKey", (Object)processInstanceKey);
        ConstantScoreQueryBuilder query = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{processInstanceKeyQuery, ACTIVE_INCIDENT_QUERY}));
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.incidentTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)query).sort("creationTime", SortOrder.ASC));
        try {
            return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll(searchRequest, IncidentEntity.class, this.objectMapper, this.esClient));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all incidents: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public Map<Long, List<Long>> getIncidentKeysPerProcessInstance(List<Long> processInstanceKeys) {
        ConstantScoreQueryBuilder processInstanceKeysQuery = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termsQuery((String)"processInstanceKey", processInstanceKeys), ACTIVE_INCIDENT_QUERY}));
        int batchSize = this.operateProperties.getElasticsearch().getBatchSize();
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest(this.incidentTemplate, ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query((QueryBuilder)processInstanceKeysQuery).fetchSource("processInstanceKey", null).size(batchSize));
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>();
        try {
            this.tenantAwareClient.search(searchRequest, () -> {
                ElasticsearchUtil.scrollWith(searchRequest, this.esClient, searchHits -> {
                    for (SearchHit hit : searchHits.getHits()) {
                        CollectionUtil.addToMap((Map)result, (Object)Long.valueOf(hit.getSourceAsMap().get("processInstanceKey").toString()), (Object)Long.valueOf(hit.getId()));
                    }
                }, null, null);
                return null;
            });
            return result;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining all incidents: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }
}

