/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.elasticsearch;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.exceptions.PersistenceException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.store.BatchRequest;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={ElasticsearchCondition.class})
@Scope(value="prototype")
public class ElasticsearchBatchRequest
implements BatchRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchBatchRequest.class);
    private final BulkRequest bulkRequest = new BulkRequest();
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private RestHighLevelClient esClient;

    @Override
    public BatchRequest add(String index, OperateEntity entity) throws PersistenceException {
        return this.addWithId(index, entity.getId(), entity);
    }

    @Override
    public BatchRequest addWithId(String index, String id, OperateEntity entity) throws PersistenceException {
        LOGGER.debug("Add index request for index {} id {} and entity {} ", new Object[]{index, id, entity});
        try {
            this.bulkRequest.add(new IndexRequest(index).id(id).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to index [%s] of entity type [%s] ", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest addWithRouting(String index, OperateEntity entity, String routing) throws PersistenceException {
        LOGGER.debug("Add index request with routing {} for index {} and entity {} ", new Object[]{routing, index, entity});
        try {
            this.bulkRequest.add(new IndexRequest(index).id(entity.getId()).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).routing(routing));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to index [%s] of entity type [%s] with routing", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest upsert(String index, String id, OperateEntity entity, Map<String, Object> updateFields) throws PersistenceException {
        LOGGER.debug("Add upsert request for index {} id {} entity {} and update fields {}", new Object[]{index, id, entity, updateFields});
        try {
            this.bulkRequest.add(((UpdateRequest)new UpdateRequest().index(index)).id(id).doc((Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class)).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert [%s] of entity type [%s]", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest upsertWithRouting(String index, String id, OperateEntity entity, Map<String, Object> updateFields, String routing) throws PersistenceException {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and update fields {}", new Object[]{routing, index, id, entity, updateFields});
        try {
            this.bulkRequest.add(((UpdateRequest)new UpdateRequest().index(index)).id(id).doc((Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class)).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).routing(routing).retryOnConflict(3));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert [%s] of entity type [%s] with routing", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest upsertWithScript(String index, String id, OperateEntity entity, String script, Map<String, Object> parameters) throws PersistenceException {
        LOGGER.debug("Add upsert request with for index {} id {} entity {} and script {} with parameters {} ", new Object[]{index, id, entity, script, parameters});
        try {
            this.bulkRequest.add(((UpdateRequest)new UpdateRequest().index(index)).id(id).script(this.getScriptWithParameters(script, parameters)).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).retryOnConflict(3));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert [%s] of entity type [%s] with script and routing", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest upsertWithScriptAndRouting(String index, String id, OperateEntity entity, String script, Map<String, Object> parameters, String routing) throws PersistenceException {
        LOGGER.debug("Add upsert request with routing {} for index {} id {} entity {} and script {} with parameters {} ", new Object[]{routing, index, id, entity, script, parameters});
        try {
            this.bulkRequest.add(((UpdateRequest)new UpdateRequest().index(index)).id(id).script(this.getScriptWithParameters(script, parameters)).upsert(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON).routing(routing).retryOnConflict(3));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to upsert [%s] of entity type [%s] with script and routing", entity.getClass().getName(), entity), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, Map<String, Object> updateFields) throws PersistenceException {
        LOGGER.debug("Add update request for index {} id {} and update fields {}", new Object[]{index, id, updateFields});
        try {
            this.bulkRequest.add(((UpdateRequest)new UpdateRequest().index(index)).id(id).doc((Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(updateFields), HashMap.class)).retryOnConflict(3));
        }
        catch (JsonProcessingException e) {
            throw new PersistenceException(String.format("Error preparing the query to update index [%s] document with id [%s]", index, id), (Throwable)e);
        }
        return this;
    }

    @Override
    public BatchRequest update(String index, String id, OperateEntity entity) throws PersistenceException {
        try {
            return this.update(index, id, (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString((Object)entity), HashMap.class));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public BatchRequest updateWithScript(String index, String id, String script, Map<String, Object> parameters) throws PersistenceException {
        LOGGER.debug("Add update with script request for index {} id {} ", (Object)index, (Object)id);
        UpdateRequest updateRequest = ((UpdateRequest)new UpdateRequest().index(index)).id(id).script(this.getScriptWithParameters(script, parameters)).retryOnConflict(3);
        this.bulkRequest.add(updateRequest);
        return this;
    }

    @Override
    public void execute() throws PersistenceException {
        LOGGER.debug("Execute batchRequest with {} requests", (Object)this.bulkRequest.requests().size());
        ElasticsearchUtil.processBulkRequest(this.esClient, this.bulkRequest, this.operateProperties.getElasticsearch().getBulkRequestMaxSizeInBytes());
    }

    @Override
    public void executeWithRefresh() throws PersistenceException {
        LOGGER.debug("Execute batchRequest with {} requests and refresh", (Object)this.bulkRequest.requests().size());
        ElasticsearchUtil.processBulkRequest(this.esClient, this.bulkRequest, true, this.operateProperties.getElasticsearch().getBulkRequestMaxSizeInBytes());
    }

    private Script getScriptWithParameters(String script, Map<String, Object> parameters) throws PersistenceException {
        try {
            return new Script(ScriptType.INLINE, "painless", script, (Map)this.objectMapper.readValue(this.objectMapper.writeValueAsString(parameters), HashMap.class));
        }
        catch (IOException e) {
            throw new PersistenceException((Throwable)e);
        }
    }
}

