/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.opensearch;

import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.PipelineReindexPlan;
import io.camunda.operate.schema.migration.ReindexPlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch.core.ReindexRequest;
import org.opensearch.client.opensearch.core.reindex.Destination;
import org.opensearch.client.opensearch.core.reindex.Source;
import org.opensearch.client.util.ObjectBuilder;

public class OpensearchPipelineReindexPlan
extends PipelineReindexPlan
implements ReindexPlan {
    private final RichOpenSearchClient richOpenSearchClient;
    private final MigrationProperties migrationProperties;
    private Script script;

    public OpensearchPipelineReindexPlan(RichOpenSearchClient richOpenSearchClient, MigrationProperties migrationProperties) {
        this.richOpenSearchClient = richOpenSearchClient;
        this.migrationProperties = migrationProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        Optional<String> pipelineName = this.createPipelineFromSteps(schemaManager);
        if (this.script == null) {
            this.buildScript("ctx._index = params.dstIndex+'_' + (ctx._index.substring(ctx._index.indexOf('_') + 1, ctx._index.length()));", Map.of("dstIndex", this.dstIndex));
        }
        ReindexRequest.Builder reindexRequest = new ReindexRequest.Builder().source(Source.of(b -> b.index(this.srcIndex + "_*", new String[0]).size(Integer.valueOf(this.migrationProperties.getReindexBatchSize())))).dest(Destination.of(b -> {
            b.index(this.dstIndex + "_");
            pipelineName.ifPresent(arg_0 -> ((Destination.Builder)b).pipeline(arg_0));
            return b;
        }));
        if (this.script != null) {
            reindexRequest.script(this.script);
        }
        if (this.migrationProperties.getSlices() > 0) {
            reindexRequest.slices(Long.valueOf(this.migrationProperties.getSlices()));
        }
        try {
            this.richOpenSearchClient.index().reindexWithRetries(reindexRequest.build());
        }
        finally {
            pipelineName.ifPresent(schemaManager::removePipeline);
        }
    }

    @Override
    protected String getPipelineDefinition() {
        List stepsAsJSON = CollectionUtil.map((Collection)this.steps, Step::getContent);
        return "{ \"processors\": [" + String.join((CharSequence)", ", stepsAsJSON) + "] }";
    }

    private void buildScript(String scriptContent, Map<String, Object> params) {
        HashMap<String, JsonData> paramsMap = new HashMap<String, JsonData>();
        for (Map.Entry<String, Object> param : params.entrySet()) {
            paramsMap.put(param.getKey(), JsonData.of((Object)param.getValue()));
        }
        this.script = (Script)new Script.Builder().inline(InlineScript.of(s -> (ObjectBuilder)s.lang("painless").source(scriptContent).params(paramsMap))).build();
    }

    public String toString() {
        return "OpensearchReindexPlan [steps=" + String.valueOf(this.steps) + ",  srcIndex=" + this.srcIndex + ", dstIndex=" + this.dstIndex + "]";
    }
}

