/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.schema.migration.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.post.PostImporterActionType;
import io.camunda.operate.entities.post.PostImporterQueueEntity;
import io.camunda.operate.exceptions.MigrationException;
import io.camunda.operate.property.MigrationProperties;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.SchemaManager;
import io.camunda.operate.schema.migration.FillPostImporterQueuePlan;
import io.camunda.operate.schema.migration.Step;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.util.LambdaExceptionUtil;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ElasticsearchFillPostImporterQueuePlan
implements FillPostImporterQueuePlan {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchFillPostImporterQueuePlan.class);
    private final OperateProperties operateProperties;
    private final MigrationProperties migrationProperties;
    private final ObjectMapper objectMapper;
    private final RestHighLevelClient esClient;
    private Long flowNodesWithIncidentsCount;
    private List<Step> steps;
    private String listViewIndexName;
    private String incidentsIndexName;
    private String postImporterQueueIndexName;

    public ElasticsearchFillPostImporterQueuePlan(OperateProperties operateProperties, MigrationProperties migrationProperties, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper, RestHighLevelClient esClient) {
        this.operateProperties = operateProperties;
        this.migrationProperties = migrationProperties;
        this.objectMapper = objectMapper;
        this.esClient = esClient;
    }

    @Override
    public FillPostImporterQueuePlan setListViewIndexName(String listViewIndexName) {
        this.listViewIndexName = listViewIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setIncidentsIndexName(String incidentsIndexName) {
        this.incidentsIndexName = incidentsIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setPostImporterQueueIndexName(String postImporterQueueIndexName) {
        this.postImporterQueueIndexName = postImporterQueueIndexName;
        return this;
    }

    @Override
    public FillPostImporterQueuePlan setSteps(List<Step> steps) {
        this.steps = steps;
        return this;
    }

    @Override
    public List<Step> getSteps() {
        return this.steps;
    }

    @Override
    public void executeOn(SchemaManager schemaManager) throws MigrationException {
        long srcCount = schemaManager.getNumberOfDocumentsFor(this.postImporterQueueIndexName);
        if (srcCount > 0L) {
            LOGGER.info("No migration needed for postImporterQueueIndex, already contains data.");
            return;
        }
        String incidentKeysFieldName = "incidentKeys";
        SearchRequest searchRequest = new SearchRequest(new String[]{this.listViewIndexName + "*"}).source(new SearchSourceBuilder().query(ElasticsearchUtil.joinWithAnd(new QueryBuilder[]{QueryBuilders.termQuery((String)"joinRelation", (String)"activity"), QueryBuilders.termQuery((String)"pendingIncident", (boolean)true)})).fetchSource("incidentKeys", null).sort("id").size(this.operateProperties.getElasticsearch().getBatchSize()));
        try {
            ElasticsearchUtil.scroll(searchRequest, LambdaExceptionUtil.rethrowConsumer(hits -> {
                if (this.flowNodesWithIncidentsCount == null) {
                    this.flowNodesWithIncidentsCount = hits.getTotalHits().value;
                }
                List<IncidentEntity> incidents = this.getIncidentEntities("incidentKeys", this.esClient, (SearchHits)hits);
                BulkRequest bulkRequest = new BulkRequest();
                int[] index = new int[]{0};
                for (IncidentEntity incident : incidents) {
                    index[0] = index[0] + 1;
                    PostImporterQueueEntity entity = this.createPostImporterQueueEntity(incident, index[0]);
                    bulkRequest.add(((IndexRequest)new IndexRequest().index(this.postImporterQueueIndexName)).source(this.objectMapper.writeValueAsString((Object)entity), XContentType.JSON));
                }
                ElasticsearchUtil.processBulkRequest(this.esClient, bulkRequest, this.operateProperties.getElasticsearch().getBulkRequestMaxSizeInBytes());
            }), this.esClient, this.migrationProperties.getScrollKeepAlive());
        }
        catch (Exception e) {
            throw new MigrationException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void validateMigrationResults(SchemaManager schemaManager) throws MigrationException {
        long dstCount = schemaManager.getNumberOfDocumentsFor(this.postImporterQueueIndexName);
        if (this.flowNodesWithIncidentsCount != null && this.flowNodesWithIncidentsCount > dstCount) {
            throw new MigrationException(String.format("Exception occurred when migrating %s. Number of flow nodes with pending incidents: %s, number of documents in post-importer-queue: %s", this.postImporterQueueIndexName, this.flowNodesWithIncidentsCount, dstCount));
        }
    }

    private List<IncidentEntity> getIncidentEntities(String incidentKeysFieldName, RestHighLevelClient esClient, SearchHits hits) throws IOException {
        List incidentKeys = Arrays.stream(hits.getHits()).map(sh -> (List)sh.getSourceAsMap().get(incidentKeysFieldName)).flatMap(Collection::stream).collect(Collectors.toList());
        SearchRequest incidentSearchRequest = new SearchRequest(new String[]{this.incidentsIndexName + "*"}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termsQuery((String)"id", incidentKeys)).sort("id").size(this.operateProperties.getElasticsearch().getBatchSize()));
        SearchResponse incidentsResponse = esClient.search(incidentSearchRequest, RequestOptions.DEFAULT);
        List<IncidentEntity> incidents = ElasticsearchUtil.mapSearchHits(incidentsResponse.getHits().getHits(), this.objectMapper, IncidentEntity.class);
        return incidents;
    }

    private PostImporterQueueEntity createPostImporterQueueEntity(IncidentEntity incident, long index) {
        return ((PostImporterQueueEntity)new PostImporterQueueEntity().setId(String.format("%s-%s", incident.getId(), incident.getState().getZeebeIntent()))).setCreationTime(OffsetDateTime.now()).setKey(incident.getKey()).setIntent(incident.getState().getZeebeIntent()).setPosition(index).setPartitionId(incident.getPartitionId()).setActionType(PostImporterActionType.INCIDENT).setProcessInstanceKey(incident.getProcessInstanceKey());
    }

    public String toString() {
        return "ElasticsearchFillPostImporterQueuePlan{listViewIndexName='" + this.listViewIndexName + "', incidentsIndexName='" + this.incidentsIndexName + "', postImporterQueueIndexName='" + this.postImporterQueueIndexName + "', operateProperties=" + String.valueOf(this.operateProperties) + ", migrationProperties=" + String.valueOf(this.migrationProperties) + ", objectMapper=" + String.valueOf(this.objectMapper) + ", flowNodesWithIncidentsCount=" + this.flowNodesWithIncidentsCount + "}";
    }
}

