/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.store.opensearch.dsl;

import io.camunda.operate.tenant.TenantCheckApplierHolder;
import io.camunda.operate.util.CollectionUtil;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.opensearch._types.FieldValue;
import org.opensearch.client.opensearch._types.InlineScript;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.BoolQuery;
import org.opensearch.client.opensearch._types.query_dsl.ChildScoreMode;
import org.opensearch.client.opensearch._types.query_dsl.ConstantScoreQuery;
import org.opensearch.client.opensearch._types.query_dsl.ExistsQuery;
import org.opensearch.client.opensearch._types.query_dsl.HasChildQuery;
import org.opensearch.client.opensearch._types.query_dsl.IdsQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchAllQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchNoneQuery;
import org.opensearch.client.opensearch._types.query_dsl.MatchQuery;
import org.opensearch.client.opensearch._types.query_dsl.Operator;
import org.opensearch.client.opensearch._types.query_dsl.PrefixQuery;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch._types.query_dsl.RangeQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQuery;
import org.opensearch.client.opensearch._types.query_dsl.TermsQueryField;
import org.opensearch.client.opensearch._types.query_dsl.WildcardQuery;
import org.opensearch.client.opensearch.core.search.SourceConfig;

public interface QueryDSL {
    public static final String DEFAULT_SCRIPT_LANG = "painless";

    private static <A> List<A> nonNull(A[] items) {
        return QueryDSL.nonNull(Arrays.asList(items));
    }

    private static <A> List<A> nonNull(Collection<A> items) {
        return items.stream().filter(Objects::nonNull).toList();
    }

    private static Map<String, JsonData> jsonParams(Map<String, Object> params) {
        return params.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> QueryDSL.json(e.getValue())));
    }

    public static Query and(Query ... queries) {
        return BoolQuery.of(q -> q.must(QueryDSL.nonNull(queries)))._toQuery();
    }

    public static Query and(List<Query> queries) {
        return BoolQuery.of(q -> q.must(QueryDSL.nonNull(queries)))._toQuery();
    }

    public static Query withTenantCheck(Query query) {
        try {
            return TenantCheckApplierHolder.getOpenSearchTenantCheckApplier().map(tenantCheckApplier -> (Query)tenantCheckApplier.apply((Object)query)).orElse(query);
        }
        catch (Exception e) {
            return query;
        }
    }

    public static Query constantScore(Query query) {
        return ConstantScoreQuery.of(q -> q.filter(query))._toQuery();
    }

    public static Query exists(String field) {
        return ExistsQuery.of(q -> q.field(field))._toQuery();
    }

    public static <A> Query gt(String field, A gt) {
        return RangeQuery.of(q -> q.field(field).gt(QueryDSL.json(gt)))._toQuery();
    }

    public static <A> Query gteLte(String field, A gte, A lte) {
        return RangeQuery.of(q -> q.field(field).gte(QueryDSL.json(gte)).lte(QueryDSL.json(lte)))._toQuery();
    }

    public static <A> Query gtLte(String field, A gt, A lte) {
        return RangeQuery.of(q -> q.field(field).gt(QueryDSL.json(gt)).lte(QueryDSL.json(lte)))._toQuery();
    }

    public static Query hasChildQuery(String type, Query query) {
        return HasChildQuery.of(q -> q.query(query).type(type).scoreMode(ChildScoreMode.None))._toQuery();
    }

    public static Query ids(List<String> ids) {
        return IdsQuery.of(q -> q.values(QueryDSL.nonNull(ids)))._toQuery();
    }

    public static Query ids(Collection<String> ids) {
        return IdsQuery.of(q -> q.values(ids.stream().toList()))._toQuery();
    }

    public static Query ids(String ... ids) {
        return QueryDSL.ids(List.of(ids));
    }

    public static <C extends Collection<Integer>> Query intTerms(String field, C values) {
        return QueryDSL.terms(field, values, FieldValue::of);
    }

    public static <A> JsonData json(A value) {
        return JsonData.of((Object)(value == null ? JsonValue.NULL : value));
    }

    public static <C extends Collection<Long>> Query longTerms(String field, C values) {
        return QueryDSL.terms(field, values, FieldValue::of);
    }

    public static <A> Query terms(String field, Collection<A> values, Function<A, FieldValue> toFieldValue) {
        List<FieldValue> fieldValues = values.stream().map(toFieldValue).toList();
        return TermsQuery.of(q -> q.field(field).terms(TermsQueryField.of(f -> f.value(fieldValues))))._toQuery();
    }

    public static <A> Query lte(String field, A lte) {
        return RangeQuery.of(q -> q.field(field).lte(QueryDSL.json(lte)))._toQuery();
    }

    public static <A> Query match(String field, A value, Operator operator, Function<A, FieldValue> toFieldValue) {
        return new MatchQuery.Builder().field(field).query(toFieldValue.apply(value)).operator(operator).build()._toQuery();
    }

    public static Query match(String field, String value, Operator operator) {
        return QueryDSL.match(field, value, operator, FieldValue::of);
    }

    public static Query matchAll() {
        return new MatchAllQuery.Builder().build()._toQuery();
    }

    public static Query matchNone() {
        return new MatchNoneQuery.Builder().build()._toQuery();
    }

    public static Query not(Query ... queries) {
        return BoolQuery.of(q -> q.mustNot(QueryDSL.nonNull(queries)))._toQuery();
    }

    public static Query or(Query ... queries) {
        return BoolQuery.of(q -> q.should(QueryDSL.nonNull(queries)))._toQuery();
    }

    public static Query prefix(String field, String value) {
        return PrefixQuery.of(q -> q.field(field).value(value))._toQuery();
    }

    public static SortOrder reverseOrder(SortOrder sortOrder) {
        return sortOrder == SortOrder.Asc ? SortOrder.Desc : SortOrder.Asc;
    }

    public static Script script(String script, Map<String, Object> params) {
        return (Script)new Script.Builder().inline(b -> ((InlineScript.Builder)b.source(script).params(QueryDSL.jsonParams(params))).lang(DEFAULT_SCRIPT_LANG)).build();
    }

    public static SortOptions sortOptions(String field, SortOrder sortOrder) {
        return SortOptions.of(so -> so.field(sf -> sf.field(field).order(sortOrder)));
    }

    public static SortOptions sortOptions(String field, SortOrder sortOrder, String missing) {
        return SortOptions.of(so -> so.field(sf -> sf.field(field).order(sortOrder).missing(m -> m.stringValue(missing))));
    }

    public static SourceConfig sourceInclude(String ... fields) {
        if (CollectionUtil.isEmpty((Object[])fields)) {
            return QueryDSL.sourceInclude(List.of());
        }
        return QueryDSL.sourceInclude(List.of(fields));
    }

    public static SourceConfig sourceExclude(String ... fields) {
        if (CollectionUtil.isEmpty((Object[])fields)) {
            return QueryDSL.sourceExclude(List.of());
        }
        return QueryDSL.sourceExclude(List.of(fields));
    }

    public static SourceConfig sourceIncludesExcludes(String[] includes, String[] excludes) {
        return QueryDSL.sourceIncludesExcludes(includes == null ? List.of() : List.of(includes), excludes == null ? List.of() : List.of(excludes));
    }

    public static SourceConfig sourceExclude(List<String> fields) {
        return SourceConfig.of(s -> s.filter(f -> f.excludes(fields)));
    }

    public static SourceConfig sourceInclude(List<String> fields) {
        return SourceConfig.of(s -> s.filter(f -> f.includes(fields)));
    }

    public static SourceConfig sourceIncludesExcludes(List<String> includes, List<String> excludes) {
        return SourceConfig.of(s -> s.filter(f -> f.includes(includes).excludes(excludes)));
    }

    public static <C extends Collection<String>> Query stringTerms(String field, C values) {
        return QueryDSL.terms(field, values, FieldValue::of);
    }

    public static Query term(String field, Integer value) {
        return QueryDSL.term(field, value, FieldValue::of);
    }

    public static Query term(String field, Long value) {
        return QueryDSL.term(field, value, FieldValue::of);
    }

    public static Query term(String field, String value) {
        return QueryDSL.term(field, value, FieldValue::of);
    }

    public static Query term(String field, boolean value) {
        return QueryDSL.term(field, value, FieldValue::of);
    }

    public static <A> Query term(String field, A value, Function<A, FieldValue> toFieldValue) {
        return TermQuery.of(q -> q.field(field).value((FieldValue)toFieldValue.apply(value)))._toQuery();
    }

    public static Query wildcardQuery(String field, String value) {
        return WildcardQuery.of(q -> q.field(field).value(value))._toQuery();
    }

    public static Query matchDateQuery(String name, String dateAsString, String dateFormat) {
        return RangeQuery.of(q -> q.field(name).gte(QueryDSL.json(dateAsString)).lte(QueryDSL.json(dateAsString)).format(dateFormat))._toQuery();
    }
}

